/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.server.worker.jobmaster.GaugeData;
import io.mantisrx.server.worker.jobmaster.MetricData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class WorkerMetrics {
    private final int valuesToKeepPerMetric;
    private final ConcurrentMap<String, List<GaugeData>> gaugesByMetricGrp = new ConcurrentHashMap<String, List<GaugeData>>();

    public WorkerMetrics(int valuesToKeepPerMetric) {
        this.valuesToKeepPerMetric = valuesToKeepPerMetric;
    }

    public GaugeData transform(String metricGroupName, GaugeData data) {
        if (metricGroupName.equals("DataDrop")) {
            Map<String, Double> gauges = data.getGauges();
            if (gauges.containsKey("dropCount") && gauges.containsKey("onNextCount")) {
                Double onNextCount = gauges.get("onNextCount");
                Double dropCount = gauges.get("dropCount");
                double totalCount = dropCount + onNextCount;
                if (totalCount > 0.0) {
                    double dropPercent = dropCount * 100.0 / totalCount;
                    HashMap<String, Double> newGauges = new HashMap<String, Double>(2);
                    newGauges.put("dropPercent", dropPercent);
                    newGauges.put("onNextCount", gauges.get("onNextCount"));
                    return new GaugeData(data.getWhen(), newGauges);
                }
            } else if (gauges.containsKey("onNextCount")) {
                return new GaugeData(data.getWhen(), Collections.singletonMap("onNextCount", gauges.get("onNextCount")));
            }
            return new GaugeData(data.getWhen(), Collections.emptyMap());
        }
        return data;
    }

    public MetricData addDataPoint(String metricGroupName, MetricData metricData) {
        if (!this.gaugesByMetricGrp.containsKey(metricGroupName)) {
            this.gaugesByMetricGrp.putIfAbsent(metricGroupName, new CopyOnWriteArrayList());
        }
        GaugeData transformed = this.transform(metricGroupName, metricData.getGaugeData());
        ((List)this.gaugesByMetricGrp.get(metricGroupName)).add(transformed);
        if (((List)this.gaugesByMetricGrp.get(metricGroupName)).size() > this.valuesToKeepPerMetric) {
            ((List)this.gaugesByMetricGrp.get(metricGroupName)).remove(0);
        }
        return new MetricData(metricData.getJobId(), metricData.getStage(), metricData.getWorkerIndex(), metricData.getWorkerNumber(), metricData.getMetricGroupName(), transformed);
    }

    public Map<String, List<GaugeData>> getGaugesByMetricGrp() {
        return this.gaugesByMetricGrp;
    }
}

