/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadJob {
    private static final Logger logger = LoggerFactory.getLogger(DownloadJob.class);
    private URL jobArtifactUrl;
    private String jobName;
    private String locationToStore;

    public DownloadJob(URL jobArtifactUrl, String jobName, String locationToStore) {
        this.jobArtifactUrl = jobArtifactUrl;
        this.locationToStore = locationToStore;
        this.jobName = jobName;
    }

    public static void main(String[] args) throws MalformedURLException {
        if (args.length < 3) {
            System.err.println("usage: job_artifact_url job_name location_to_store");
            System.exit(1);
        }
        logger.info("parameters, jobArtifactUrl: " + args[0]);
        logger.info("parameters, jobName: " + args[1]);
        logger.info("parameters, locationToStore: " + args[2]);
        new DownloadJob(new URL(args[0]), args[1], args[2]).execute();
    }

    public void execute() {
        String jobJarFile = this.jobArtifactUrl.getFile();
        String jarName = jobJarFile.substring(jobJarFile.lastIndexOf(47) + 1);
        Path path = Paths.get(this.locationToStore, this.jobName, "lib");
        logger.info("Started writing job to tmp directory: " + path);
        try (InputStream is = this.jobArtifactUrl.openStream();){
            Files.createDirectories(path, new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(Paths.get(path.toString(), jarName), new OpenOption[0]);){
                byte[] bytes = new byte[2048];
                int read = 0;
                while ((read = is.read(bytes)) >= 0) {
                    os.write(bytes, 0, read);
                }
            }
        }
        catch (IOException e1) {
            logger.error("Failed to write job to local store at path: " + path, (Throwable)e1);
            throw new RuntimeException(e1);
        }
        logger.info("Finished writing job to tmp directory: " + path);
    }
}

