/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.codec.Encoder;
import io.reactivex.mantis.remote.observable.MutableReference;
import io.reactivex.mantis.remote.observable.ServeConfig;
import io.reactivex.mantis.remote.observable.filter.ServerSideFilters;
import io.reactivex.mantis.remote.observable.slotting.RoundRobin;
import io.reactivex.mantis.remote.observable.slotting.SlottingStrategy;
import java.util.Map;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public class ServeObservable<T>
extends ServeConfig<T, T> {
    private Encoder<T> encoder;
    private Observable<T> observable;
    private boolean subscriptionPerConnection;
    private boolean isHotStream;

    public ServeObservable(Builder<T> builder) {
        super(((Builder)builder).name, ((Builder)builder).slottingStrategy, ((Builder)builder).filterFunction, ((Builder)builder).maxWriteAttempts);
        this.encoder = ((Builder)builder).encoder;
        this.subscriptionPerConnection = ((Builder)builder).subscriptionPerConnection;
        this.isHotStream = builder.isHotStream;
        this.observable = ((Builder)builder).observable;
        if (!((Builder)builder).subscriptionPerConnection) {
            this.applySlottingSideEffectToObservable(((Builder)builder).observable);
        }
    }

    public boolean isSubscriptionPerConnection() {
        return this.subscriptionPerConnection;
    }

    public Observable<T> getObservable() {
        return this.observable;
    }

    public boolean isHotStream() {
        return this.isHotStream;
    }

    private void applySlottingSideEffectToObservable(Observable<T> o) {
        final Observable withSideEffects = o.doOnNext(new Action1<T>(){

            public void call(T t) {
                ServeObservable.this.slottingStrategy.writeOnSlot(null, t);
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                ServeObservable.this.slottingStrategy.completeAllConnections();
            }
        });
        final MutableReference subscriptionRef = new MutableReference();
        this.slottingStrategy.registerDoAfterFirstConnectionAdded(new Action0(){

            public void call() {
                subscriptionRef.setValue(withSideEffects.subscribe());
            }
        });
        this.slottingStrategy.registerDoAfterLastConnectionRemoved(new Action0(){

            public void call() {
                ((Subscription)subscriptionRef.getValue()).unsubscribe();
            }
        });
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    public static class Builder<T> {
        public boolean isHotStream;
        private String name;
        private Observable<T> observable;
        private SlottingStrategy<T> slottingStrategy = new RoundRobin();
        private Encoder<T> encoder;
        private Func1<Map<String, String>, Func1<T, Boolean>> filterFunction = ServerSideFilters.noFiltering();
        private int maxWriteAttempts;
        private boolean subscriptionPerConnection;

        public Builder<T> name(String name) {
            if (name != null && name.length() > 127) {
                throw new IllegalArgumentException("Observable name must be less than 127 characters");
            }
            this.name = name;
            return this;
        }

        public Builder<T> observable(Observable<T> observable) {
            this.observable = observable;
            return this;
        }

        public Builder<T> maxWriteAttempts(Observable<T> observable) {
            this.observable = observable;
            return this;
        }

        public Builder<T> slottingStrategy(SlottingStrategy<T> slottingStrategy) {
            this.slottingStrategy = slottingStrategy;
            return this;
        }

        public Builder<T> encoder(Encoder<T> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder<T> serverSideFilter(Func1<Map<String, String>, Func1<T, Boolean>> filterFunc) {
            this.filterFunction = filterFunc;
            return this;
        }

        public ServeObservable<T> build() {
            return new ServeObservable(this);
        }

        public Builder<T> subscriptionPerConnection() {
            this.subscriptionPerConnection = true;
            return this;
        }

        public Builder<T> hotStream() {
            this.isHotStream = true;
            return this;
        }
    }
}

