/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable.slotting;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.network.HashFunction;
import io.mantisrx.common.network.HashFunctions;
import io.mantisrx.common.network.ServerSlotManager;
import io.mantisrx.common.network.WritableEndpoint;
import io.reactivex.mantis.remote.observable.slotting.SlottingStrategy;
import java.util.LinkedList;
import java.util.List;

public class ConsistentHashing<T>
extends SlottingStrategy<T> {
    private ServerSlotManager.SlotAssignmentManager<T> manager;
    private List<WritableEndpoint<T>> connections = new LinkedList<WritableEndpoint<T>>();
    private Gauge activeConnections;
    private Metrics metrics;

    public ConsistentHashing(String ringName, HashFunction function) {
        this.manager = new ServerSlotManager.SlotAssignmentManager(function, ringName);
        this.metrics = new Metrics.Builder().name("ConsistentHashing").addGauge("activeConnections").build();
        this.activeConnections = this.metrics.getGauge("activeConnections");
    }

    public ConsistentHashing() {
        this("default-ring", HashFunctions.ketama());
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public synchronized boolean addConnection(WritableEndpoint<T> endpoint) {
        boolean wasEmpty = this.manager.isEmpty();
        boolean isRegistered = this.manager.forceRegisterServer(endpoint);
        if (wasEmpty && isRegistered) {
            this.doAfterFirstConnectionAdded.call();
        }
        if (isRegistered) {
            this.connections.add(endpoint);
            this.doOnEachConnectionAdded.call();
        }
        this.activeConnections.set((long)this.connections.size());
        return isRegistered;
    }

    @Override
    public synchronized boolean removeConnection(WritableEndpoint<T> endpoint) {
        boolean isDeregistered = this.connections.remove(endpoint);
        if (isDeregistered && this.connections.isEmpty()) {
            this.doAfterLastConnectionRemoved.call();
        }
        if (isDeregistered) {
            this.doOnEachConnectionRemoved.call();
        }
        this.activeConnections.set((long)this.connections.size());
        return isDeregistered;
    }

    @Override
    public void writeOnSlot(byte[] keyBytes, T data) {
        this.manager.lookup(keyBytes).write(data);
    }

    @Override
    public synchronized void completeAllConnections() {
        for (WritableEndpoint endpoint : this.manager.endpoints()) {
            endpoint.complete();
        }
    }

    @Override
    public synchronized void errorAllConnections(Throwable e) {
        for (WritableEndpoint endpoint : this.manager.endpoints()) {
            endpoint.error(e);
        }
    }
}

