/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.network.Endpoint;
import java.util.HashMap;
import java.util.Map;
import rx.functions.Action0;
import rx.subjects.PublishSubject;

public abstract class ConnectToConfig {
    private Endpoint endpoint;
    private String name;
    private Map<String, String> subscribeParameters = new HashMap<String, String>();
    private int subscribeAttempts;
    private boolean suppressDecodingErrors = false;
    private Action0 connectionDisconnectCallback;
    private PublishSubject<Integer> closeTrigger;

    public ConnectToConfig(String host, int port, String name, Map<String, String> subscribeParameters, int subscribeAttempts, boolean suppressDecodingErrors, Action0 connectionDisconnectCallback, PublishSubject<Integer> closeTrigger) {
        this.endpoint = new Endpoint(host, port);
        this.name = name;
        this.subscribeParameters.putAll(subscribeParameters);
        this.subscribeAttempts = subscribeAttempts;
        this.suppressDecodingErrors = suppressDecodingErrors;
        this.connectionDisconnectCallback = connectionDisconnectCallback;
        this.closeTrigger = closeTrigger;
    }

    public Action0 getConnectionDisconnectCallback() {
        return this.connectionDisconnectCallback;
    }

    public PublishSubject<Integer> getCloseTrigger() {
        return this.closeTrigger;
    }

    public String getHost() {
        return this.endpoint.getHost();
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getSubscribeParameters() {
        return this.subscribeParameters;
    }

    public int getSubscribeAttempts() {
        return this.subscribeAttempts;
    }

    public boolean isSuppressDecodingErrors() {
        return this.suppressDecodingErrors;
    }
}

