/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.server.core.ServiceRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.reactivex.mantis.remote.observable.BatchedRxEventPipelineConfigurator;
import io.reactivex.mantis.remote.observable.HeartbeatHandler;
import io.reactivex.mantis.remote.observable.RemoteObservableConnectionHandler;
import io.reactivex.mantis.remote.observable.RemoteRxEvent;
import io.reactivex.mantis.remote.observable.RxMetrics;
import io.reactivex.mantis.remote.observable.ServeConfig;
import io.reactivex.mantis.remote.observable.ServeGroupedObservable;
import io.reactivex.mantis.remote.observable.ServeNestedObservable;
import io.reactivex.mantis.remote.observable.ServeObservable;
import io.reactivex.mantis.remote.observable.ingress.IngressPolicies;
import io.reactivex.mantis.remote.observable.ingress.IngressPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import mantis.io.reactivex.netty.server.RxServer;
import mantis.io.reactivex.netty.server.ServerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRxServer {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRxServer.class);
    private static boolean enableHeartBeating = true;
    private static boolean enableNettyLogging = false;
    private static boolean enableCompression = true;
    private static int maxFrameLength = 0x500000;
    private static int writeBufferTimeMSec = 100;
    private RxServer<RemoteRxEvent, List<RemoteRxEvent>> server;
    private RxMetrics metrics;
    private int port;

    RemoteRxServer(RxServer<RemoteRxEvent, List<RemoteRxEvent>> server, RxMetrics metrics) {
        this.server = server;
        this.metrics = metrics;
        this.loadFastProperties();
    }

    public RemoteRxServer() {
        this.metrics = new RxMetrics();
    }

    public RemoteRxServer(Builder builder) {
        RxServer server;
        this.port = builder.getPort();
        HashMap<String, ServeConfig> configuredObservables = new HashMap<String, ServeConfig>();
        for (ServeConfig config : builder.getObservablesConfigured()) {
            String observableName = config.getName();
            logger.debug("RemoteRxServer configured with remote observable: " + observableName);
            configuredObservables.put(observableName, config);
        }
        this.metrics = new RxMetrics();
        this.server = server = (RxServer)((ServerBuilder)((ServerBuilder)((ServerBuilder)RxNetty.newTcpServerBuilder((int)this.port, (ConnectionHandler)new RemoteObservableConnectionHandler(configuredObservables, builder.getIngressPolicy(), this.metrics, writeBufferTimeMSec)).pipelineConfigurator((PipelineConfigurator)new PipelineConfiguratorComposite(new PipelineConfigurator[]{new PipelineConfigurator<RemoteRxEvent, RemoteRxEvent>(){

            public void configureNewPipeline(ChannelPipeline pipeline) {
                if (enableNettyLogging) {
                    pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.ERROR)});
                }
                if (enableHeartBeating) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(10, 2, 0));
                    pipeline.addLast("heartbeat", (ChannelHandler)new HeartbeatHandler());
                }
                if (enableCompression) {
                    pipeline.addLast("gzipInflater", (ChannelHandler)new JdkZlibEncoder(ZlibWrapper.GZIP));
                    pipeline.addLast("gzipDeflater", (ChannelHandler)new JdkZlibDecoder(ZlibWrapper.GZIP));
                }
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(maxFrameLength, 0, 4, 0, 4));
            }
        }, new BatchedRxEventPipelineConfigurator()}))).channelOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)0x500000)).channelOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)0x100000)).build();
        logger.info("RemoteRxServer started on port: " + this.port);
    }

    public RxMetrics getMetrics() {
        return this.metrics;
    }

    public void start() {
        this.server.start();
    }

    public void startAndWait() {
        this.server.startAndWait();
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    public void shutdown() {
        try {
            this.server.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    public void blockUntilServerShutdown() {
        try {
            this.server.waitTillShutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    private void loadFastProperties() {
        String writeBufferTimeMSecStr;
        String maxFrameLengthStr;
        String enableCompressionStr;
        String enableNettyLoggingStr;
        String enableHeartBeatingStr = ServiceRegistry.INSTANCE.getPropertiesService().getStringValue("mantis.netty.enableHeartBeating", "true");
        if (enableHeartBeatingStr.equals("false")) {
            enableHeartBeating = false;
        }
        if ((enableNettyLoggingStr = ServiceRegistry.INSTANCE.getPropertiesService().getStringValue("mantis.netty.enableLogging", "false")).equals("true")) {
            enableNettyLogging = true;
        }
        if ((enableCompressionStr = ServiceRegistry.INSTANCE.getPropertiesService().getStringValue("mantis.netty.enableCompression", "true")).equals("false")) {
            enableCompression = false;
        }
        if ((maxFrameLengthStr = ServiceRegistry.INSTANCE.getPropertiesService().getStringValue("mantis.netty.maxFrameLength", "5242880")) != null && maxFrameLengthStr.length() > 0) {
            maxFrameLength = Integer.parseInt(maxFrameLengthStr);
        }
        if ((writeBufferTimeMSecStr = ServiceRegistry.INSTANCE.getPropertiesService().getStringValue("mantis.netty.writeBufferTimeMSec", "100")) != null && writeBufferTimeMSecStr.length() > 0) {
            writeBufferTimeMSec = Integer.parseInt(maxFrameLengthStr);
        }
    }

    public static class Builder {
        private int port;
        private Set<ServeConfig> observablesConfigured = new HashSet<ServeConfig>();
        private IngressPolicy ingressPolicy = IngressPolicies.allowAll();

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ingressPolicy(IngressPolicy ingressPolicy) {
            this.ingressPolicy = ingressPolicy;
            return this;
        }

        public <T> Builder addObservable(ServeObservable<T> configuration) {
            this.observablesConfigured.add(configuration);
            return this;
        }

        public <T> Builder addObservable(ServeNestedObservable<T> configuration) {
            this.observablesConfigured.add(configuration);
            return this;
        }

        public <K, V> Builder addObservable(ServeGroupedObservable<K, V> configuration) {
            this.observablesConfigured.add(configuration);
            return this;
        }

        public RemoteRxServer build() {
            return new RemoteRxServer(this);
        }

        int getPort() {
            return this.port;
        }

        Set<ServeConfig> getObservablesConfigured() {
            return this.observablesConfigured;
        }

        IngressPolicy getIngressPolicy() {
            return this.ingressPolicy;
        }
    }
}

