/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.guice;

import com.google.inject.AbstractModule;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.ipc.http.HttpClient;
import io.mantisrx.publish.DefaultSubscriptionTracker;
import io.mantisrx.publish.EventChannel;
import io.mantisrx.publish.EventTransmitter;
import io.mantisrx.publish.MantisEventPublisher;
import io.mantisrx.publish.MrePublishClientInitializer;
import io.mantisrx.publish.NoOpTee;
import io.mantisrx.publish.StreamManager;
import io.mantisrx.publish.SubscriptionTracker;
import io.mantisrx.publish.Tee;
import io.mantisrx.publish.api.EventPublisher;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.config.SampleArchaiusMrePublishConfiguration;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import io.mantisrx.publish.internal.discovery.MantisJobDiscoveryCachingImpl;
import io.mantisrx.publish.internal.discovery.mantisapi.DefaultMantisApiClient;
import io.mantisrx.publish.internal.discovery.mantisapi.MantisApiClient;
import io.mantisrx.publish.netty.pipeline.HttpEventChannel;
import io.mantisrx.publish.netty.pipeline.HttpEventChannelManager;
import io.mantisrx.publish.netty.transmitters.ChoiceOfTwoEventTransmitter;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

public class MantisRealtimeEventsPublishModule
extends AbstractModule {
    protected void configure() {
        this.bind(MrePublishConfiguration.class).toProvider(MrePublishConfigProvider.class).asEagerSingleton();
        this.bind(StreamManager.class).toProvider(StreamManagerProvider.class).asEagerSingleton();
        this.bind(EventPublisher.class).toProvider(EventPublisherProvider.class).asEagerSingleton();
        this.bind(MantisJobDiscovery.class).toProvider(MantisJobDiscoveryProvider.class).asEagerSingleton();
        this.bind(EventTransmitter.class).toProvider(EventTransmitterProvider.class).asEagerSingleton();
        this.bind(Tee.class).toProvider(TeeProvider.class).asEagerSingleton();
        this.bind(SubscriptionTracker.class).toProvider(SubscriptionTrackerProvider.class).asEagerSingleton();
        this.bind(MrePublishClientInitializer.class).toProvider(MrePublishClientInitializerProvider.class).asEagerSingleton();
    }

    @Singleton
    private static class MantisJobDiscoveryProvider
    implements Provider<MantisJobDiscovery> {
        @Inject
        private MrePublishConfiguration configuration;
        @Inject
        private Registry registry;

        private MantisJobDiscoveryProvider() {
        }

        public MantisJobDiscovery get() {
            return new MantisJobDiscoveryCachingImpl(this.configuration, this.registry, (MantisApiClient)new DefaultMantisApiClient(this.configuration, HttpClient.create((Registry)this.registry)));
        }
    }

    @Singleton
    private static class MrePublishConfigProvider
    implements Provider<MrePublishConfiguration> {
        @Inject
        private PropertyRepository propertyRepository;

        private MrePublishConfigProvider() {
        }

        public MrePublishConfiguration get() {
            return new SampleArchaiusMrePublishConfiguration(this.propertyRepository);
        }
    }

    @Singleton
    private static class SubscriptionTrackerProvider
    implements Provider<SubscriptionTracker> {
        @Inject
        private MrePublishConfiguration configuration;
        @Inject
        private Registry registry;
        @Inject
        private StreamManager streamManager;
        @Inject
        private MantisJobDiscovery jobDiscovery;

        private SubscriptionTrackerProvider() {
        }

        public SubscriptionTracker get() {
            return new DefaultSubscriptionTracker(this.configuration, this.registry, this.streamManager, HttpClient.create((Registry)this.registry), this.jobDiscovery);
        }
    }

    @Singleton
    private static class TeeProvider
    implements Provider<Tee> {
        @Inject
        Registry registry;

        private TeeProvider() {
        }

        public Tee get() {
            return new NoOpTee(this.registry);
        }
    }

    @Singleton
    private static class EventPublisherProvider
    implements Provider<EventPublisher> {
        @Inject
        private MrePublishConfiguration config;
        @Inject
        private StreamManager streamManager;

        private EventPublisherProvider() {
        }

        public EventPublisher get() {
            return new MantisEventPublisher(this.config, this.streamManager);
        }
    }

    @Singleton
    private static class StreamManagerProvider
    implements Provider<StreamManager> {
        @Inject
        private MrePublishConfiguration configuration;
        @Inject
        private Registry registry;

        private StreamManagerProvider() {
        }

        public StreamManager get() {
            return new StreamManager(this.registry, this.configuration);
        }
    }

    @Singleton
    private static class EventTransmitterProvider
    implements Provider<EventTransmitter> {
        @Inject
        private MrePublishConfiguration configuration;
        @Inject
        private Registry registry;
        @Inject
        private MantisJobDiscovery jobDiscovery;

        private EventTransmitterProvider() {
        }

        public EventTransmitter get() {
            HttpEventChannelManager channelManager = new HttpEventChannelManager(this.registry, this.configuration);
            HttpEventChannel eventChannel = new HttpEventChannel(this.registry, channelManager);
            return new ChoiceOfTwoEventTransmitter(this.configuration, this.registry, this.jobDiscovery, (EventChannel)eventChannel);
        }
    }

    @Singleton
    private static class MrePublishClientInitializerProvider
    implements Provider<MrePublishClientInitializer> {
        @Inject
        private MrePublishConfiguration config;
        @Inject
        private PropertyRepository propertyRepository;
        @Inject
        private Registry registry;
        @Inject
        private StreamManager streamManager;
        @Inject
        private EventPublisher eventPublisher;
        @Inject
        private MantisJobDiscovery jobDiscovery;
        @Inject
        private SubscriptionTracker subscriptionsTracker;
        @Inject
        private EventTransmitter eventTransmitter;
        @Inject
        private Tee tee;

        private MrePublishClientInitializerProvider() {
        }

        public MrePublishClientInitializer get() {
            MrePublishClientInitializer mreClient = new MrePublishClientInitializer(this.config, this.registry, this.streamManager, this.eventPublisher, this.subscriptionsTracker, this.eventTransmitter, this.tee);
            mreClient.start();
            return mreClient;
        }
    }
}

