/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.discovery;

import io.mantisrx.discovery.proto.AppJobClustersMap;
import io.mantisrx.discovery.proto.JobDiscoveryInfo;
import io.mantisrx.discovery.proto.MantisWorker;
import io.mantisrx.discovery.proto.StageWorkers;
import io.mantisrx.discovery.proto.StreamJobClusterMap;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import io.mantisrx.publish.internal.discovery.MantisJobDiscoveryCachingImpl;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisJobDiscoveryStaticImpl
implements MantisJobDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(MantisJobDiscoveryCachingImpl.class);
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String DEFAULT_JOB_CLUSTER = "SharedMrePublishEventSource";
    private static final String JOB_CLUSTER_LOOKUP_FAILED = "JobClusterLookupFailed";
    String mreAppJobClusterMapStr = "{\"version\": \"1\", \"timestamp\": 12345, \"mappings\": {\"__default__\": {\"requestEventStream\": \"SharedPushRequestEventSource\",\"__default__\": \"SharedMrePublishEventSource\"}}}";
    private AppJobClustersMap appJobClustersMap;
    private String workerHost;
    private int workerPort;

    public MantisJobDiscoveryStaticImpl(String host, int port) {
        try {
            this.workerHost = host;
            this.workerPort = port;
            this.appJobClustersMap = (AppJobClustersMap)mapper.readValue(this.mreAppJobClusterMapStr, AppJobClustersMap.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<AppJobClustersMap> getJobClusterMappings(String app) {
        return Optional.of(this.appJobClustersMap);
    }

    @Override
    public Optional<JobDiscoveryInfo> getCurrentJobWorkers(String jobCluster) {
        HashMap<Integer, StageWorkers> stageWorkersMap = new HashMap<Integer, StageWorkers>();
        ArrayList<MantisWorker> workerList = new ArrayList<MantisWorker>();
        MantisWorker mantisWorker = new MantisWorker(this.workerHost, this.workerPort);
        workerList.add(mantisWorker);
        stageWorkersMap.put(1, new StageWorkers(jobCluster, jobCluster + "-1", 1, workerList));
        JobDiscoveryInfo jobDiscoveryInfo = new JobDiscoveryInfo(jobCluster, jobCluster + "-1", stageWorkersMap);
        return Optional.of(jobDiscoveryInfo);
    }

    @Override
    public Map<String, String> getStreamNameToJobClusterMapping(String app) {
        String appName = DEFAULT_JOB_CLUSTER;
        Optional<AppJobClustersMap> jobClusterMappingsO = this.getJobClusterMappings(appName);
        if (jobClusterMappingsO.isPresent()) {
            AppJobClustersMap appJobClustersMap = jobClusterMappingsO.get();
            StreamJobClusterMap streamJobClusterMap = appJobClustersMap.getStreamJobClusterMap(appName);
            return streamJobClusterMap.getStreamJobClusterMap();
        }
        logger.info("Failed to lookup stream to job cluster mapping for app {}", (Object)appName);
        return Collections.emptyMap();
    }

    @Override
    public String getJobCluster(String app, String stream) {
        String appName = DEFAULT_JOB_CLUSTER;
        Optional<AppJobClustersMap> jobClusterMappingsO = this.getJobClusterMappings(appName);
        if (jobClusterMappingsO.isPresent()) {
            AppJobClustersMap appJobClustersMap = jobClusterMappingsO.get();
            StreamJobClusterMap streamJobClusterMap = appJobClustersMap.getStreamJobClusterMap(appName);
            return streamJobClusterMap.getJobCluster(stream);
        }
        logger.info("Failed to lookup job cluster for app {} stream {}", (Object)appName, (Object)stream);
        return JOB_CLUSTER_LOOKUP_FAILED;
    }
}

