/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.mql;

import io.mantisrx.mql.jvm.core.Query;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.core.Subscription;
import io.mantisrx.publish.internal.mql.MQL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQLSubscription
implements Subscription,
Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(MQLSubscription.class);
    protected final Query query;
    private AtomicBoolean matcherErrorLoggingEnabled;
    private AtomicBoolean projectorErrorLoggingEnabled;
    private ConcurrentHashMap<HashSet<Query>, Function<Map<String, Object>, Map<String, Object>>> superSetProjectorCache = new ConcurrentHashMap();

    public MQLSubscription(String subId, String criterion) {
        this.matcherErrorLoggingEnabled = new AtomicBoolean(true);
        this.projectorErrorLoggingEnabled = new AtomicBoolean(true);
        this.query = MQL.query(subId, MQL.preprocess(criterion));
    }

    private Map<String, Object> projectSuperSet(Collection<Query> queries, Map<String, Object> datum) {
        Function superSetProjector = this.superSetProjectorCache.computeIfAbsent(new HashSet<Query>(queries), MQL::makeSupersetProjector);
        return (Map)superSetProjector.apply(datum);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public String getRawQuery() {
        return this.query.getRawQuery();
    }

    @Override
    public String getSubscriptionId() {
        return this.query.getSubscriptionId();
    }

    @Override
    public Event projectSuperset(List<Subscription> subscriptions, Event event) {
        ArrayList<Query> queries = new ArrayList<Query>(subscriptions.size());
        for (Subscription sub : subscriptions) {
            queries.add(sub.getQuery());
        }
        try {
            return new Event(this.projectSuperSet(queries, event.getMap()));
        }
        catch (Exception e) {
            if (this.projectorErrorLoggingEnabled.get()) {
                LOG.error("MQL projector produced an exception on queries: {}\ndatum: {}.", queries, event.getMap());
                this.projectorErrorLoggingEnabled.set(false);
            }
            Event error = new Event();
            error.set("message", e.getMessage());
            error.set("queries", queries.stream().map(Query::getRawQuery).collect(Collectors.joining(", ")));
            return error;
        }
    }

    @Override
    public boolean matches(Event event) {
        try {
            return this.query.matches(event.getMap());
        }
        catch (Exception ex) {
            if (this.matcherErrorLoggingEnabled.get()) {
                LOG.error("MQL matcher produced an exception on query: {}\ndatum: {}.", (Object)this.query.getRawQuery(), event.getMap());
                this.matcherErrorLoggingEnabled.set(false);
            }
            return false;
        }
    }

    private List<String> sanitizeStreamSubjects(List<String> subjects) {
        return subjects.stream().map(s -> {
            if (s.toLowerCase().equals("observable") || s.toLowerCase().equals("stream") || s.toLowerCase().equals("defaultstream")) {
                return "__default__";
            }
            return s;
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getSubjects() {
        return this.sanitizeStreamSubjects(this.getSubjectsInternal());
    }

    public List<String> getSubjectsInternal() {
        return this.query.getSubjects();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MQLSubscription other = (MQLSubscription)obj;
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }

    public int compareTo(Object o) {
        MQLSubscription other = (MQLSubscription)o;
        if (this.equals(other)) {
            return 0;
        }
        if (other != null) {
            if (this.query.equals(other.query)) {
                return 0;
            }
            int result = this.getSubscriptionId().compareTo(other.getSubscriptionId());
            result = result == 0 ? this.getRawQuery().compareTo(other.getRawQuery()) : result;
            return result == 0 ? -1 : result;
        }
        return -1;
    }

    public String toString() {
        return "MQLSubscription [subId=" + this.query.getSubscriptionId() + ", criterion=" + this.query.getRawQuery() + "]";
    }
}

