/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.proto;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceInfo {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceInfo.class);
    private final String applicationName;
    private final String zone;
    private final String clusterName;
    private final String autoScalingGroupName;
    private volatile InstanceStatus instanceStatus = InstanceStatus.UNKNOWN;

    public InstanceInfo(String applicationName, String zone, String clusterName, String autoScalingGroupName) {
        this.applicationName = applicationName;
        this.zone = zone;
        this.clusterName = clusterName;
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getZone() {
        return this.zone;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public void setInstanceStatus(InstanceStatus status) {
        this.instanceStatus = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceInfo that = (InstanceInfo)o;
        return Objects.equals(this.getApplicationName(), that.getApplicationName()) && Objects.equals(this.getZone(), that.getZone()) && Objects.equals(this.getClusterName(), that.getClusterName()) && Objects.equals(this.getAutoScalingGroupName(), that.getAutoScalingGroupName());
    }

    public int hashCode() {
        return Objects.hash(this.getApplicationName(), this.getZone(), this.getClusterName(), this.getAutoScalingGroupName());
    }

    public String toString() {
        return "InstanceInfo{applicationName='" + this.applicationName + '\'' + ", zone='" + this.zone + '\'' + ", clusterName='" + this.clusterName + '\'' + ", autoScalingGroupName='" + this.autoScalingGroupName + '\'' + ", instanceStatus=" + (Object)((Object)this.instanceStatus) + '}';
    }

    public static enum InstanceStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static InstanceStatus toEnum(String s) {
            if (s != null) {
                try {
                    return InstanceStatus.valueOf(s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOG.debug("illegal argument supplied to InstanceStatus.valueOf: {}, defaulting to {}", (Object)s, (Object)UNKNOWN);
                }
            }
            return UNKNOWN;
        }
    }
}

