/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.metrics;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.AtomicDouble;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import java.util.concurrent.atomic.AtomicLong;

public class StreamMetrics {
    private final String streamName;
    private final Counter mantisEventsDroppedCounter;
    private final Counter mantisEventsProcessedCounter;
    private final Counter mantisEventsSkippedCounter;
    private final Counter mantisQueryRejectedCounter;
    private final Counter mantisQueryFailedCounter;
    private final Counter mantisQueryProjectionFailedCounter;
    private final AtomicDouble mantisEventsQueuedGauge;
    private final AtomicDouble mantisActiveQueryCountGauge;
    private final Timer mantisEventsProcessTimeTimer;
    private final AtomicLong lastEventOnStreamTimestamp = new AtomicLong(0L);

    public StreamMetrics(Registry registry, String streamName) {
        this.streamName = streamName;
        this.mantisEventsDroppedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisEventsDropped", "stream", streamName, "reason", "publisherQueueFull");
        this.mantisEventsProcessedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisEventsProcessed", "stream", streamName);
        this.mantisEventsSkippedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisEventsSkipped", "stream", streamName);
        this.mantisQueryRejectedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisQueryRejected", "stream", streamName);
        this.mantisQueryFailedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisQueryFailed", "stream", streamName);
        this.mantisQueryProjectionFailedCounter = SpectatorUtils.buildAndRegisterCounter(registry, "mantisQueryProjectionFailed", "stream", streamName);
        this.mantisEventsQueuedGauge = SpectatorUtils.buildAndRegisterGauge(registry, "mantisEventsQueued", "stream", streamName);
        this.mantisActiveQueryCountGauge = SpectatorUtils.buildAndRegisterGauge(registry, "mantisActiveQueryCount", "stream", streamName);
        this.mantisEventsProcessTimeTimer = SpectatorUtils.buildAndRegisterTimer(registry, "mantisEventsProcessTime", "stream", streamName);
        this.updateLastEventOnStreamTimestamp();
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Counter getMantisEventsDroppedCounter() {
        return this.mantisEventsDroppedCounter;
    }

    public Counter getMantisEventsProcessedCounter() {
        return this.mantisEventsProcessedCounter;
    }

    public Counter getMantisEventsSkippedCounter() {
        return this.mantisEventsSkippedCounter;
    }

    public Counter getMantisQueryRejectedCounter() {
        return this.mantisQueryRejectedCounter;
    }

    public Counter getMantisQueryFailedCounter() {
        return this.mantisQueryFailedCounter;
    }

    public Counter getMantisQueryProjectionFailedCounter() {
        return this.mantisQueryProjectionFailedCounter;
    }

    public AtomicDouble getMantisEventsQueuedGauge() {
        return this.mantisEventsQueuedGauge;
    }

    public AtomicDouble getMantisActiveQueryCountGauge() {
        return this.mantisActiveQueryCountGauge;
    }

    public Timer getMantisEventsProcessTimeTimer() {
        return this.mantisEventsProcessTimeTimer;
    }

    public void updateLastEventOnStreamTimestamp() {
        this.lastEventOnStreamTimestamp.set(System.nanoTime());
    }

    public long getLastEventOnStreamTimestamp() {
        return this.lastEventOnStreamTimestamp.get();
    }
}

