/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish;

import io.mantisrx.publish.StreamManager;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.api.EventPublisher;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.metrics.StreamMetrics;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisEventPublisher
implements EventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MantisEventPublisher.class);
    private final MrePublishConfiguration mrePublishConfiguration;
    private final StreamManager streamManager;

    public MantisEventPublisher(MrePublishConfiguration mrePublishConfiguration, StreamManager streamManager) {
        this.mrePublishConfiguration = mrePublishConfiguration;
        this.streamManager = streamManager;
    }

    @Override
    public void publish(Event event) {
        this.publish("defaultStream", event);
    }

    @Override
    public void publish(String streamName, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        Optional<BlockingQueue<Event>> streamQ = this.streamManager.registerStream(streamName);
        if (streamQ.isPresent()) {
            Optional<StreamMetrics> streamMetricsO = this.streamManager.getStreamMetrics(streamName);
            if (this.hasSubscriptions(streamName) || this.isTeeEnabled()) {
                boolean success = streamQ.get().offer(event);
                if (!success) {
                    streamMetricsO.ifPresent(m -> m.getMantisEventsDroppedCounter().increment());
                } else {
                    streamMetricsO.ifPresent(m -> m.getMantisEventsProcessedCounter().increment());
                }
            } else {
                streamMetricsO.ifPresent(m -> {
                    m.getMantisActiveQueryCountGauge().set(0.0);
                    m.getMantisEventsSkippedCounter().increment();
                });
            }
        }
    }

    @Override
    public boolean hasSubscriptions(String streamName) {
        if (!this.isEnabled()) {
            LOG.debug("Mantis publish client is not enabled");
            return false;
        }
        this.streamManager.registerStream(streamName);
        return this.streamManager.hasSubscriptions(streamName);
    }

    private boolean isEnabled() {
        return this.mrePublishConfiguration.isMREClientEnabled();
    }

    private boolean isTeeEnabled() {
        return this.mrePublishConfiguration.isTeeEnabled();
    }
}

