/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.discovery.mantisapi;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.mantis.discovery.proto.AppJobClustersMap;
import com.netflix.mantis.discovery.proto.JobDiscoveryInfo;
import com.netflix.mantis.discovery.proto.MantisWorker;
import com.netflix.mantis.discovery.proto.StageWorkers;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.ipc.http.HttpClient;
import com.netflix.spectator.ipc.http.HttpResponse;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.config.SampleArchaiusMrePublishConfiguration;
import io.mantisrx.publish.internal.discovery.mantisapi.MantisApiClient;
import io.mantisrx.publish.internal.discovery.proto.JobSchedulingInfo;
import io.mantisrx.publish.internal.discovery.proto.MantisJobState;
import io.mantisrx.publish.internal.discovery.proto.WorkerAssignments;
import io.mantisrx.publish.internal.discovery.proto.WorkerHost;
import io.mantisrx.publish.internal.exceptions.NonRetryableException;
import io.mantisrx.publish.internal.exceptions.RetryableException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMantisApiClient
implements MantisApiClient {
    private static final int CONNECT_TIMEOUT_MS = 1000;
    private static final int READ_TIMEOUT_MS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(DefaultMantisApiClient.class);
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String JOB_CLUSTER_MAPPING_URL_FORMAT = "http://%s:%d/api/v1/mantis/publish/streamJobClusterMap";
    private static final String JOB_DISCOVERY_URL_FORMAT = "http://%s:%d/jobClusters/discoveryInfo/%s";
    private static final String JOB_DISCOVERY_STREAM_URL_FORMAT = "http://%s:%d/assignmentresults/%s";
    private final MrePublishConfiguration mrePublishConfiguration;
    private final HttpClient httpClient;

    public DefaultMantisApiClient(MrePublishConfiguration mrePublishConfiguration, HttpClient client) {
        this.mrePublishConfiguration = mrePublishConfiguration;
        this.httpClient = client;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, TimeoutException {
        DefaultRegistry registry = new DefaultRegistry();
        DefaultPropertyFactory props = DefaultPropertyFactory.from((Config)new DefaultSettableConfig());
        DefaultMantisApiClient defaultMantisApiClient = new DefaultMantisApiClient(new SampleArchaiusMrePublishConfiguration((PropertyRepository)props), HttpClient.create((Registry)registry));
        CompletableFuture<JobDiscoveryInfo> jobDiscoveryInfoCompletableFuture = defaultMantisApiClient.jobDiscoveryInfo("MREPushSourceJob");
        JobDiscoveryInfo jobDiscoveryInfo = jobDiscoveryInfoCompletableFuture.get(1L, TimeUnit.SECONDS);
        System.out.println(jobDiscoveryInfo.toString());
        CompletableFuture<AppJobClustersMap> jobClusterMapping = defaultMantisApiClient.getJobClusterMapping(Optional.of("testApp"));
        AppJobClustersMap appJobClustersMap = jobClusterMapping.get(1L, TimeUnit.SECONDS);
        System.out.println(appJobClustersMap.toString());
    }

    @Override
    public CompletableFuture<AppJobClustersMap> getJobClusterMapping(Optional<String> app) {
        return CompletableFuture.supplyAsync(() -> {
            StringBuilder uriBuilder = new StringBuilder(String.format(JOB_CLUSTER_MAPPING_URL_FORMAT, this.mrePublishConfiguration.discoveryApiHostname(), this.mrePublishConfiguration.discoveryApiPort()));
            app.ifPresent(appName -> uriBuilder.append("?app=").append((String)appName));
            String uri = uriBuilder.toString();
            logger.debug("job cluster mapping fetch url {}", (Object)uri);
            try {
                HttpResponse response = this.httpClient.get(URI.create(uri)).withConnectTimeout(1000).withReadTimeout(1000).send();
                int status = response.status();
                if (status >= 200 && status < 300) {
                    AppJobClustersMap appJobClustersMap = (AppJobClustersMap)mapper.readValue(response.entityAsString(), AppJobClustersMap.class);
                    logger.debug(appJobClustersMap.toString());
                    return appJobClustersMap;
                }
                if (status >= 300 && status < 500) {
                    logger.warn("got {} response from api on Job cluster mapping request for {}", (Object)status, (Object)app);
                    throw new CompletionException(new NonRetryableException("Failed to get job cluster mapping info for " + app + " status " + status));
                }
                logger.warn("got {} response from api on Job cluster mapping request for {}", (Object)status, (Object)app);
                throw new CompletionException(new RetryableException("Failed to get job job cluster mapping info for " + app + " status " + status));
            }
            catch (IOException e) {
                logger.error("caught exception", (Throwable)e);
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<JobDiscoveryInfo> jobDiscoveryInfo(String jobClusterName) {
        return CompletableFuture.supplyAsync(() -> {
            String uri = String.format(JOB_DISCOVERY_URL_FORMAT, this.mrePublishConfiguration.discoveryApiHostname(), this.mrePublishConfiguration.discoveryApiPort(), jobClusterName);
            logger.debug("discovery info fetch url {}", (Object)uri);
            try {
                HttpResponse response = this.httpClient.get(URI.create(uri)).withConnectTimeout(1000).withReadTimeout(1000).send();
                int status = response.status();
                if (status >= 200 && status < 300) {
                    JobSchedulingInfo jobSchedulingInfo = (JobSchedulingInfo)mapper.readValue(response.entityAsString(), JobSchedulingInfo.class);
                    JobDiscoveryInfo jobDiscoveryInfo = this.convertJobSchedInfo(jobSchedulingInfo, jobClusterName);
                    logger.debug(jobDiscoveryInfo.toString());
                    return jobDiscoveryInfo;
                }
                if (status >= 300 && status < 500) {
                    logger.warn("got {} response from api on Job Discovery request for {}", (Object)status, (Object)jobClusterName);
                    throw new CompletionException(new NonRetryableException("Failed to get job discovery info for " + jobClusterName + " status " + status));
                }
                logger.warn("got {} response from api on Job Discovery request for {}", (Object)status, (Object)jobClusterName);
                throw new CompletionException(new RetryableException("Failed to get job discovery info for " + jobClusterName + " status " + status));
            }
            catch (IOException e) {
                logger.error("caught exception", (Throwable)e);
                throw new CompletionException(e);
            }
        });
    }

    private JobDiscoveryInfo convertJobSchedInfo(JobSchedulingInfo jobSchedulingInfo, String jobClusterName) {
        HashMap<Integer, StageWorkers> jobWorkers = new HashMap<Integer, StageWorkers>();
        for (Map.Entry<Integer, WorkerAssignments> e : jobSchedulingInfo.getWorkerAssignments().entrySet()) {
            Integer stageNum = e.getKey();
            WorkerAssignments workerAssignments = e.getValue();
            ArrayList<MantisWorker> workerList = new ArrayList<MantisWorker>(workerAssignments.getHosts().size());
            for (WorkerHost w : workerAssignments.getHosts().values()) {
                if (!MantisJobState.Started.equals((Object)w.getState())) continue;
                workerList.add(new MantisWorker(w.getHost(), w.getCustomPort()));
            }
            jobWorkers.put(stageNum, new StageWorkers(jobClusterName, jobSchedulingInfo.getJobId(), stageNum.intValue(), workerList));
        }
        return new JobDiscoveryInfo(jobClusterName, jobSchedulingInfo.getJobId(), jobWorkers);
    }
}

