/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.netflix.mantis.discovery.proto.AppJobClustersMap;
import com.netflix.mantis.discovery.proto.JobDiscoveryInfo;
import com.netflix.mantis.discovery.proto.MantisWorker;
import com.netflix.mantis.discovery.proto.StageWorkers;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class MantisJobDiscoveryStaticImpl
implements MantisJobDiscovery {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    String mreAppJobClusterMapStr = "{\"version\": \"1\", \"timestamp\": 12345, \"mappings\": {\"__default__\": {\"requestEventStream\": \"SharedPushRequestEventSource\",\"__default__\": \"SharedPushEventSource\"}}}";
    private AppJobClustersMap appJobClustersMap;
    private String workerHost;
    private int workerPort;

    public MantisJobDiscoveryStaticImpl(String host, int port) {
        try {
            this.workerHost = host;
            this.workerPort = port;
            this.appJobClustersMap = (AppJobClustersMap)mapper.readValue(this.mreAppJobClusterMapStr, AppJobClustersMap.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<AppJobClustersMap> getJobClusterMappings(String app) {
        return Optional.of(this.appJobClustersMap);
    }

    @Override
    public Optional<JobDiscoveryInfo> getCurrentJobWorkers(String jobCluster) {
        HashMap<Integer, StageWorkers> stageWorkersMap = new HashMap<Integer, StageWorkers>();
        ArrayList<MantisWorker> workerList = new ArrayList<MantisWorker>();
        MantisWorker mantisWorker = new MantisWorker(this.workerHost, this.workerPort);
        workerList.add(mantisWorker);
        stageWorkersMap.put(1, new StageWorkers(jobCluster, jobCluster + "-1", 1, workerList));
        JobDiscoveryInfo jobDiscoveryInfo = new JobDiscoveryInfo(jobCluster, jobCluster + "-1", stageWorkersMap);
        return Optional.of(jobDiscoveryInfo);
    }
}

