/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event {
    private static final Logger LOG = LoggerFactory.getLogger(Event.class);
    private static final AtomicBoolean ERROR_LOG_ENABLED = new AtomicBoolean(true);
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();
    private final Map<String, Object> attributes;

    public Event() {
        this(null, false);
    }

    public Event(Map<String, Object> attributes) {
        this(attributes, false);
    }

    public Event(Map<String, Object> attributes, boolean deepCopy) {
        if (attributes == null || deepCopy) {
            this.attributes = new HashMap<String, Object>();
            if (attributes != null) {
                this.attributes.putAll(attributes);
            }
        } else {
            this.attributes = attributes;
        }
        JACKSON_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public Event set(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public boolean has(String key) {
        return this.attributes.containsKey(key);
    }

    public Iterator<String> keys() {
        return this.attributes.keySet().iterator();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.attributes.entrySet();
    }

    @JsonValue
    public Map<String, Object> getMap() {
        return this.attributes;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public String toJsonString() {
        try {
            return JACKSON_MAPPER.writeValueAsString(this.attributes);
        }
        catch (JsonProcessingException e) {
            if (ERROR_LOG_ENABLED.get()) {
                LOG.error("failed to serialize Event to json {}", (Object)this.attributes.toString(), (Object)e);
                ERROR_LOG_ENABLED.set(false);
            }
            LOG.debug("failed to serialize Event to json {}", (Object)this.attributes.toString(), (Object)e);
            return "";
        }
    }

    public Map<String, String> toStringMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.entries()) {
            Object val = entry.getValue();
            if (val == null) continue;
            m.put(entry.getKey(), String.valueOf(val));
        }
        return m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.attributes, event.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.toJsonString());
    }
}

