/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.config;

import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import io.mantisrx.publish.config.MrePublishConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleArchaiusMrePublishConfiguration
implements MrePublishConfiguration {
    public static final String PROP_PREFIX = "mantis.publish";
    public static final String PUBLISH_JOB_CLUSTER_PROP_PREFIX = "mantis.publish.jobcluster.";
    public static final String MRE_CLIENT_ENABLED_PROP = "mantis.publish.enabled";
    public static final String MRE_CLIENT_APP_NAME_PROP = "mantis.publish.app.name";
    public static final String MRE_CLIENT_TEE_ENABLED_PROP = "mantis.publishtee.enabled";
    public static final String MRE_CLIENT_TEE_STREAM_NAME_PROP = "mantis.publishtee.stream";
    public static final String MRE_CLIENT_BLACKLIST_KEYS_PROP = "mantis.publish.blacklist";
    public static final String MAX_SUBSCRIPTIONS_COUNT_PROP = "mantis.publish.max.subscriptions.per.stream.default";
    public static final String DRAINER_INTERVAL_MSEC_PROP = "mantis.publish.drainer.interval.msec";
    public static final String JOB_DISCOVERY_REFRESH_INTERVAL_SEC_PROP = "mantis.publish.jobdiscovery.refresh.interval.sec";
    public static final String JOB_CLUSTER_MAPPING_REFRESH_INTERVAL_SEC_PROP = "mantis.publish.jobcluster.mapping.refresh.interval.sec";
    public static final String SUBS_REFRESH_INTERVAL_SEC_PROP = "mantis.publish.subs.refresh.interval.sec";
    public static final String SUBS_EXPIRY_INTERVAL_SEC_PROP = "mantis.publish.subs.expiry.interval.sec";
    public static final String SUBS_FETCH_QUERY_PARAMS_STR_PROP = "mantis.publish.subs.fetch.query.params.string";
    public static final String DISCOVERY_API_HOSTNAME_PROP = "mantis.publish.discovery.api.hostname";
    public static final String DISCOVERY_API_PORT_PROP = "mantis.publish.discovery.api.port";
    public static final String MAX_NUM_WORKERS_FOR_SUB_REFRESH = "mantis.publish.subs.refresh.max.num.workers";
    public static final String MAX_SUBS_PER_STREAM_FORMAT = "mantis.publish.max.subscriptions.stream.%s";
    public static final String PER_STREAM_QUEUE_SIZE_FORMAT = "mantis.publish.%s.stream.queue.size";
    public static final String MAX_NUM_STREAMS_NAME = "mantis.publish.max.num.streams";
    public static final String STREAM_INACTIVE_DURATION_THRESHOLD_NAME = "mantis.publish.stream.inactive.duration.threshold.sec";
    public static final String WORKER_POOL_PROP_PREFIX = "mantis.publish.workerpool.";
    public static final String WORKER_POOL_CAPACITY_PROP = "mantis.publish.workerpool.capacity";
    public static final String WORKER_POOL_REFRESH_INTERVAL_SEC_PROP = "mantis.publish.workerpool.refresh.interval.sec";
    public static final String WORKER_POOL_WORKER_ERROR_QUOTA_PROP = "mantis.publish.workerpool.worker.error.quota";
    public static final String WORKER_POOL_WORKER_ERROR_TIMEOUT_SEC = "mantis.publish.workerpool.worker.error.timeout.sec";
    public static final String CHANNEL_PROP_PREFIX = "mantis.publish.channel.";
    public static final String CHANNEL_GZIP_ENABLED_PROP = "mantis.publish.channel.gzip.enabled";
    public static final String CHANNEL_IDLE_TIMEOUT_SEC_PROP = "mantis.publish.channel.idleTimeout.sec";
    public static final String CHANNEL_HTTP_CHUNK_SIZE_BYTES_PROP = "mantis.publish.channel.httpChunkSize.bytes";
    public static final String CHANNEL_WRITE_TIMEOUT_SEC_PROP = "mantis.publish.channel.writeTimeout.sec";
    public static final String CHANNEL_FLUSH_INTERVAL_MSEC = "mantis.publish.channel.flushInterval.msec";
    public static final String CHANNEL_FLUSH_INTERVAL_BYTES = "mantis.publish.channel.flushInterval.bytes";
    public static final String CHANNEL_LOW_WRITE_BUFFER_WATERMARK_BYTES = "mantis.publish.channel.lowWriteBufferWatermark.bytes";
    public static final String CHANNEL_HIGH_WRITE_BUFFER_WATERMARK_BYTES = "mantis.publish.channel.highWriteBufferWatermark.bytes";
    public static final String CHANNEL_IO_THREADS = "mantis.publish.channel.ioThreads";
    public static final String CHANNEL_COMPRESSION_THREADS = "mantis.publish.channel.compressionThreads";
    private final PropertyRepository propRepo;
    private final Property<Boolean> gzipEnabled;
    private final Property<Integer> idleTimeoutSeconds;
    private final Property<Integer> httpChunkSize;
    private final Property<Integer> writeTimeoutSeconds;
    private final Property<Long> flushIntervalMs;
    private final Property<Integer> flushIntervalBytes;
    private final Property<Integer> lowWriteBufferWatermark;
    private final Property<Integer> highWriteBufferWatermark;
    private final Property<Integer> ioThreads;
    private final Property<Integer> compressionThreads;
    private final Property<Boolean> mreClientEnabled;
    private final Property<String> appName;
    private final Property<Boolean> mreClientTeeEnabled;
    private final Property<String> mreClientTeeStreamName;
    private final Property<String> blacklistedKeys;
    private final Property<Integer> maxNumWorkersForSubsRefresh;
    private final Property<Integer> maxNumStreams;
    private final Property<Long> streamInactiveDurationThreshold;
    private final Property<Integer> maxSubscriptionCount;
    private final Map<String, Property<Integer>> maxSubsByStreamType = new HashMap<String, Property<Integer>>();
    private final Map<String, Property<Integer>> queueSizeByStreamType = new HashMap<String, Property<Integer>>();
    private final Map<String, Property<String>> jobClusterByStreamType = new HashMap<String, Property<String>>();
    private final Property<String> subsFetchQueryParamStr;
    private final Property<String> discoveryApiHostnameProp;
    private final Property<Integer> discoveryApiPortProp;
    private final Property<Integer> drainerIntervalMSecProp;
    private final Property<Integer> jobDiscoveryRefreshIntervalSecProp;
    private final Property<Integer> jobClusterMappingRefreshIntervalSecProp;
    private final Property<Integer> subscriptionRefreshIntervalSecProp;
    private final Property<Integer> subscriptionExpiryIntervalSecProp;
    private final Property<Integer> workerPoolRefreshIntervalSec;
    private final Property<Integer> workerPoolCapacity;
    private final Property<Integer> workerPoolWorkerErrorQuota;
    private final Property<Integer> workerPoolWorkerErrorTimeoutSec;
    private static final Logger LOG = LoggerFactory.getLogger(SampleArchaiusMrePublishConfiguration.class);

    public SampleArchaiusMrePublishConfiguration(PropertyRepository propertyRepository) {
        this.propRepo = propertyRepository;
        this.mreClientEnabled = propertyRepository.get(MRE_CLIENT_ENABLED_PROP, Boolean.class).orElse((Object)true);
        this.appName = propertyRepository.get(MRE_CLIENT_APP_NAME_PROP, String.class).orElse((Object)"unknownApp");
        this.mreClientTeeEnabled = propertyRepository.get(MRE_CLIENT_TEE_ENABLED_PROP, Boolean.class).orElse((Object)false);
        this.mreClientTeeStreamName = propertyRepository.get(MRE_CLIENT_TEE_STREAM_NAME_PROP, String.class).orElse((Object)"default_stream");
        this.blacklistedKeys = propertyRepository.get(MRE_CLIENT_BLACKLIST_KEYS_PROP, String.class).orElse((Object)"param.password");
        this.maxNumWorkersForSubsRefresh = propertyRepository.get(MAX_NUM_WORKERS_FOR_SUB_REFRESH, Integer.class).orElse((Object)3);
        this.maxNumStreams = propertyRepository.get(MAX_NUM_STREAMS_NAME, Integer.class).orElse((Object)5);
        this.streamInactiveDurationThreshold = propertyRepository.get(STREAM_INACTIVE_DURATION_THRESHOLD_NAME, Long.class).orElse((Object)86400L);
        this.maxSubscriptionCount = propertyRepository.get(MAX_SUBSCRIPTIONS_COUNT_PROP, Integer.class).orElse((Object)20);
        this.jobClusterByStreamType.put("defaultStream", (Property<String>)this.propRepo.get("mantis.publish.jobcluster.defaultStream", String.class).orElse((Object)"SharedMrePublishEventSource"));
        this.jobClusterByStreamType.put("logEventStream", (Property<String>)this.propRepo.get("mantis.publish.jobcluster.logEventStream", String.class).orElse((Object)"SharedPushLogEventSource"));
        this.drainerIntervalMSecProp = this.propRepo.get(DRAINER_INTERVAL_MSEC_PROP, Integer.class).orElse((Object)100);
        this.jobDiscoveryRefreshIntervalSecProp = this.propRepo.get(JOB_DISCOVERY_REFRESH_INTERVAL_SEC_PROP, Integer.class).orElse((Object)10);
        this.jobClusterMappingRefreshIntervalSecProp = this.propRepo.get(JOB_CLUSTER_MAPPING_REFRESH_INTERVAL_SEC_PROP, Integer.class).orElse((Object)60);
        this.subscriptionRefreshIntervalSecProp = this.propRepo.get(SUBS_REFRESH_INTERVAL_SEC_PROP, Integer.class).orElse((Object)1);
        this.subscriptionExpiryIntervalSecProp = this.propRepo.get(SUBS_EXPIRY_INTERVAL_SEC_PROP, Integer.class).orElse((Object)300);
        this.subsFetchQueryParamStr = this.propRepo.get(SUBS_FETCH_QUERY_PARAMS_STR_PROP, String.class).orElse((Object)"");
        this.discoveryApiHostnameProp = this.propRepo.get(DISCOVERY_API_HOSTNAME_PROP, String.class).orElse((Object)"127.0.0.1");
        this.discoveryApiPortProp = this.propRepo.get(DISCOVERY_API_PORT_PROP, Integer.class).orElse((Object)80);
        this.gzipEnabled = this.propRepo.get(CHANNEL_GZIP_ENABLED_PROP, Boolean.class).orElse((Object)true);
        this.idleTimeoutSeconds = this.propRepo.get(CHANNEL_IDLE_TIMEOUT_SEC_PROP, Integer.class).orElse((Object)300);
        this.httpChunkSize = this.propRepo.get(CHANNEL_HTTP_CHUNK_SIZE_BYTES_PROP, Integer.class).orElse((Object)32768);
        this.writeTimeoutSeconds = this.propRepo.get(CHANNEL_WRITE_TIMEOUT_SEC_PROP, Integer.class).orElse((Object)1);
        this.flushIntervalMs = this.propRepo.get(CHANNEL_FLUSH_INTERVAL_MSEC, Long.class).orElse((Object)50L);
        this.flushIntervalBytes = this.propRepo.get(CHANNEL_FLUSH_INTERVAL_BYTES, Integer.class).orElse((Object)524288);
        this.lowWriteBufferWatermark = this.propRepo.get(CHANNEL_LOW_WRITE_BUFFER_WATERMARK_BYTES, Integer.class).orElse((Object)0x180000);
        this.highWriteBufferWatermark = this.propRepo.get(CHANNEL_HIGH_WRITE_BUFFER_WATERMARK_BYTES, Integer.class).orElse((Object)0x200000);
        this.ioThreads = this.propRepo.get(CHANNEL_IO_THREADS, Integer.class).orElse((Object)1);
        this.compressionThreads = this.propRepo.get(CHANNEL_COMPRESSION_THREADS, Integer.class).orElse((Object)1);
        this.workerPoolCapacity = this.propRepo.get(WORKER_POOL_CAPACITY_PROP, Integer.class).orElse((Object)1000);
        this.workerPoolRefreshIntervalSec = this.propRepo.get(WORKER_POOL_REFRESH_INTERVAL_SEC_PROP, Integer.class).orElse((Object)10);
        this.workerPoolWorkerErrorQuota = this.propRepo.get(WORKER_POOL_WORKER_ERROR_QUOTA_PROP, Integer.class).orElse((Object)60);
        this.workerPoolWorkerErrorTimeoutSec = this.propRepo.get(WORKER_POOL_WORKER_ERROR_TIMEOUT_SEC, Integer.class).orElse((Object)300);
    }

    @Override
    public boolean isMREClientEnabled() {
        return (Boolean)this.mreClientEnabled.get();
    }

    @Override
    public String appName() {
        return (String)this.appName.get();
    }

    @Override
    public boolean isTeeEnabled() {
        return (Boolean)this.mreClientTeeEnabled.get();
    }

    @Override
    public String teeStreamName() {
        return (String)this.mreClientTeeStreamName.get();
    }

    @Override
    public String blackListedKeysCSV() {
        return (String)this.blacklistedKeys.get();
    }

    @Override
    public int maxNumStreams() {
        return (Integer)this.maxNumStreams.get();
    }

    @Override
    public long streamInactiveDurationThreshold() {
        return (Long)this.streamInactiveDurationThreshold.get();
    }

    @Override
    public int maxSubscriptionCount() {
        return (Integer)this.maxSubscriptionCount.get();
    }

    @Override
    public int streamQueueSize(String streamName) {
        this.queueSizeByStreamType.putIfAbsent(streamName, (Property<Integer>)this.propRepo.get(String.format(PER_STREAM_QUEUE_SIZE_FORMAT, streamName), Integer.class).orElse((Object)1000));
        Property<Integer> streamQueueSizeProp = this.queueSizeByStreamType.get(streamName);
        return (Integer)streamQueueSizeProp.get();
    }

    @Override
    public int maxSubscriptions(String streamName) {
        this.maxSubsByStreamType.putIfAbsent(streamName, (Property<Integer>)this.propRepo.get(String.format(MAX_SUBS_PER_STREAM_FORMAT, streamName), Integer.class).orElse((Object)this.maxSubscriptionCount()));
        Property<Integer> maxSubsProp = this.maxSubsByStreamType.get(streamName);
        return (Integer)maxSubsProp.get();
    }

    @Override
    public Map<String, String> streamNameToJobClusterMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("defaultStream", this.mantisJobCluster("defaultStream"));
        mapping.put("logEventStream", this.mantisJobCluster("logEventStream"));
        mapping.put("requestEventStream", this.mantisJobCluster("defaultStream"));
        return mapping;
    }

    @Override
    public String mantisJobCluster(String streamName) {
        this.jobClusterByStreamType.putIfAbsent(streamName, (Property<String>)this.propRepo.get(PUBLISH_JOB_CLUSTER_PROP_PREFIX + streamName, String.class).orElse((Object)("JobClusterNotConfiguredFor" + streamName)));
        Property<String> jobClusterProp = this.jobClusterByStreamType.get(streamName);
        return (String)jobClusterProp.get();
    }

    @Override
    public int drainerIntervalMsec() {
        return (Integer)this.drainerIntervalMSecProp.get();
    }

    @Override
    public int subscriptionRefreshIntervalSec() {
        return (Integer)this.subscriptionRefreshIntervalSecProp.get();
    }

    @Override
    public int subscriptionExpiryIntervalSec() {
        return (Integer)this.subscriptionExpiryIntervalSecProp.get();
    }

    @Override
    public int jobDiscoveryRefreshIntervalSec() {
        return (Integer)this.jobDiscoveryRefreshIntervalSecProp.get();
    }

    @Override
    public int jobClusterMappingRefreshIntervalSec() {
        return (Integer)this.jobClusterMappingRefreshIntervalSecProp.get();
    }

    @Override
    public String discoveryApiHostname() {
        return (String)this.discoveryApiHostnameProp.get();
    }

    @Override
    public int discoveryApiPort() {
        return (Integer)this.discoveryApiPortProp.get();
    }

    @Override
    public int maxNumWorkersToFetchSubscriptionsFrom() {
        return (Integer)this.maxNumWorkersForSubsRefresh.get();
    }

    @Override
    public String subscriptionFetchQueryParams() {
        return (String)this.subsFetchQueryParamStr.get();
    }

    @Override
    public boolean getGzipEnabled() {
        return (Boolean)this.gzipEnabled.get();
    }

    @Override
    public int getIdleTimeoutSeconds() {
        return (Integer)this.idleTimeoutSeconds.get();
    }

    @Override
    public int getHttpChunkSize() {
        return (Integer)this.httpChunkSize.get();
    }

    @Override
    public int getWriteTimeoutSeconds() {
        return (Integer)this.writeTimeoutSeconds.get();
    }

    @Override
    public long getFlushIntervalMs() {
        return (Long)this.flushIntervalMs.get();
    }

    @Override
    public int getFlushIntervalBytes() {
        return (Integer)this.flushIntervalBytes.get();
    }

    @Override
    public int getLowWriteBufferWatermark() {
        return (Integer)this.lowWriteBufferWatermark.get();
    }

    @Override
    public int getHighWriteBufferWatermark() {
        return (Integer)this.highWriteBufferWatermark.get();
    }

    @Override
    public int getIoThreads() {
        return (Integer)this.ioThreads.get();
    }

    @Override
    public int getCompressionThreads() {
        return (Integer)this.compressionThreads.get();
    }

    @Override
    public int getWorkerPoolCapacity() {
        return (Integer)this.workerPoolCapacity.get();
    }

    @Override
    public int getWorkerPoolRefreshIntervalSec() {
        return (Integer)this.workerPoolRefreshIntervalSec.get();
    }

    @Override
    public int getWorkerPoolWorkerErrorQuota() {
        return (Integer)this.workerPoolWorkerErrorQuota.get();
    }

    @Override
    public int getWorkerPoolWorkerErrorTimeoutSec() {
        return (Integer)this.workerPoolWorkerErrorTimeoutSec.get();
    }
}

