/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.proto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MantisServerSubscription {
    private final String query;
    private final String subscriptionId;
    private final Map<String, String> additionalParams;

    public MantisServerSubscription(String subId, String query) {
        this(subId, query, new HashMap<String, String>());
    }

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisServerSubscription(@JsonProperty(value="subscriptionId") String subId, @JsonProperty(value="query") String query, @JsonProperty(value="additionalParams") Map<String, String> additionalParams) {
        this.query = query;
        this.additionalParams = additionalParams;
        this.subscriptionId = subId;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, String> getAdditionalParams() {
        return this.additionalParams;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisServerSubscription that = (MantisServerSubscription)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.subscriptionId, that.subscriptionId) && Objects.equals(this.additionalParams, that.additionalParams);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.subscriptionId, this.additionalParams);
    }

    public String toString() {
        return "MantisServerSubscription{ query='" + this.query + '\'' + ", subscriptionId='" + this.subscriptionId + '\'' + ", additionalParams=" + this.additionalParams + '}';
    }
}

