/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.core;

import io.mantisrx.publish.core.Subscription;
import io.mantisrx.publish.internal.mql.MQLSubscription;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionFactory.class);

    public static Optional<Subscription> getSubscription(String id, String criterion) {
        try {
            MQLSubscription mqlSubscription = new MQLSubscription(id, criterion);
            return Optional.ofNullable(mqlSubscription);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to get Subscription object for {} {}", new Object[]{id, criterion, t});
            }
            return Optional.empty();
        }
    }
}

