/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.MapperFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Optional;

public class OptionalSerializer
extends StdSerializer<Optional<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected final JsonInclude.Include _contentInclusion;
    protected transient PropertySerializerMap _dynamicSerializers;

    @Deprecated
    public OptionalSerializer(JavaType type2) {
        this((ReferenceType)type2, null, null);
    }

    protected OptionalSerializer(ReferenceType optionalType, TypeSerializer vts, JsonSerializer<?> valueSer) {
        super(optionalType);
        this._referredType = optionalType.getReferencedType();
        this._property = null;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = null;
        this._contentInclusion = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected OptionalSerializer(OptionalSerializer base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        super(base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
        this._contentInclusion = contentIncl == JsonInclude.Include.USE_DEFAULTS || contentIncl == JsonInclude.Include.ALWAYS ? null : contentIncl;
    }

    @Override
    public JsonSerializer<Optional<?>> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer(transformer, this._unwrapper);
        return this.withResolved(this._property, this._valueTypeSerializer, ser, unwrapper, this._contentInclusion);
    }

    protected OptionalSerializer withResolved(BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        if (this._property == prop && contentIncl == this._contentInclusion && this._valueTypeSerializer == vts && this._valueSerializer == valueSer && this._unwrapper == unwrapper) {
            return this;
        }
        return new OptionalSerializer(this, prop, vts, valueSer, unwrapper, contentIncl);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonInclude.Value incl;
        JsonInclude.Include newIncl;
        JsonSerializer<Object> ser;
        TypeSerializer vts = this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(property);
        }
        if ((ser = this.findContentSerializer(provider, property)) == null) {
            ser = this._valueSerializer;
            if (ser == null) {
                if (this._useStatic(provider, property, this._referredType)) {
                    ser = this._findSerializer(provider, this._referredType, property);
                }
            } else {
                ser = provider.handlePrimaryContextualization(ser, property);
            }
        }
        JsonInclude.Include contentIncl = this._contentInclusion;
        if (property != null && (newIncl = (incl = property.findPropertyInclusion(provider.getConfig(), Optional.class)).getContentInclusion()) != contentIncl && newIncl != JsonInclude.Include.USE_DEFAULTS) {
            contentIncl = newIncl;
        }
        return this.withResolved(property, vts, ser, this._unwrapper, contentIncl);
    }

    protected boolean _useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping(property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Optional<?> value) {
        if (value == null || !value.isPresent()) {
            return true;
        }
        if (this._contentInclusion == null) {
            return false;
        }
        Object contents = value.get();
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            try {
                ser = this._findCachedSerializer(provider, contents.getClass());
            }
            catch (JsonMappingException e2) {
                throw new RuntimeJsonMappingException(e2);
            }
        }
        return ser.isEmpty(provider, contents);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    @Override
    public void serialize(Optional<?> opt2, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!opt2.isPresent()) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(gen);
            }
            return;
        }
        Object value = opt2.get();
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, gen, provider, this._valueTypeSerializer);
        } else {
            ser.serialize(value, gen, provider);
        }
    }

    @Override
    public void serializeWithType(Optional<?> opt2, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (!opt2.isPresent()) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(gen);
            }
            return;
        }
        typeSer.writeTypePrefixForScalar(opt2, gen, Optional.class);
        this.serialize(opt2, gen, provider);
        typeSer.writeTypeSuffixForScalar(opt2, gen);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider provider, Class<?> type2) throws JsonMappingException {
        JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type2);
        if (ser == null) {
            ser = this._findSerializer(provider, type2, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type2, ser);
        }
        return ser;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type2, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type2, prop);
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, JavaType type2, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type2, prop);
    }

    protected JsonSerializer<?> findContentSerializer(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector intr;
        Object serDef;
        AnnotatedMember m;
        if (property != null && (m = property.getMember()) != null && (serDef = (intr = serializers.getAnnotationIntrospector()).findContentSerializer(m)) != null) {
            return serializers.serializerInstance(m, serDef);
        }
        return null;
    }
}

