/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish;

import io.mantisrx.publish.StreamManager;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.api.EventPublisher;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.metrics.StreamMetrics;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public class MantisEventPublisher
implements EventPublisher {
    private final MrePublishConfiguration mrePublishConfiguration;
    private final StreamManager streamManager;

    public MantisEventPublisher(MrePublishConfiguration mrePublishConfiguration, StreamManager streamManager) {
        this.mrePublishConfiguration = mrePublishConfiguration;
        this.streamManager = streamManager;
    }

    @Override
    public void publish(Event event) {
        this.publish("defaultStream", event);
    }

    @Override
    public void publish(String streamName, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        Optional<BlockingQueue<Event>> streamQ = this.streamManager.createIfAbsentQueueForStream(streamName);
        if (streamQ.isPresent()) {
            Optional<StreamMetrics> streamMetricsO = this.streamManager.getStreamMetrics(streamName);
            if (this.hasSubscriptions(streamName) || this.isTeeEnabled()) {
                boolean success2 = streamQ.get().offer(event);
                if (!success2) {
                    streamMetricsO.ifPresent(m -> m.getMantisEventsDroppedCounter().increment());
                } else {
                    streamMetricsO.ifPresent(m -> m.getMantisEventsProcessedCounter().increment());
                }
            } else {
                streamMetricsO.ifPresent(m -> {
                    m.getMantisActiveQueryCountGauge().set(0.0);
                    m.getMantisEventsSkippedCounter().increment();
                });
            }
        }
    }

    @Override
    public boolean hasSubscriptions(String streamName) {
        return this.streamManager.hasSubscriptions(streamName);
    }

    private boolean isEnabled() {
        return this.mrePublishConfiguration.isMREClientEnabled();
    }

    private boolean isTeeEnabled() {
        return this.mrePublishConfiguration.isTeeEnabled();
    }
}

