/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish;

import io.mantisrx.publish.StreamManager;
import io.mantisrx.publish.Tee;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.core.Subscription;
import io.mantisrx.publish.proto.MantisEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EventProcessor.class);
    private final MrePublishConfiguration config;
    private final StreamManager streamManager;
    private final Tee tee;
    private final Random randomGenerator;
    private final AtomicBoolean errorLogEnabled;

    EventProcessor(MrePublishConfiguration config, StreamManager streamManager, Tee tee) {
        this.config = config;
        this.streamManager = streamManager;
        this.tee = tee;
        this.randomGenerator = new Random();
        this.errorLogEnabled = new AtomicBoolean(true);
    }

    public MantisEvent process(String stream, Event event) {
        LOG.debug("Entering EventProcessor#onNext: {}", (Object)event);
        boolean isEnabled = this.config.isMREClientEnabled();
        if (!isEnabled) {
            LOG.debug("Mantis Realtime Events Publisher is disabled.Set the property defined in your MrePublishConfiguration object to true to enable.");
            return null;
        }
        this.maskSensitiveFields(event);
        if (this.config.isTeeEnabled()) {
            this.tee.tee(this.config.teeStreamName(), event);
        }
        ArrayList<Subscription> matchingSubscriptions = new ArrayList<Subscription>();
        if (this.streamManager.hasSubscriptions(stream)) {
            Set<Subscription> streamSubscriptions = this.streamManager.getStreamSubscriptions(stream);
            for (Subscription s : streamSubscriptions) {
                try {
                    if (!s.matches(event)) continue;
                    matchingSubscriptions.add(s);
                }
                catch (Exception e2) {
                    this.streamManager.getStreamMetrics(stream).ifPresent(m -> m.getMantisQueryFailedCounter().increment());
                    int rndNo = this.randomGenerator.nextInt(1000000);
                    if (rndNo >= 10) continue;
                    this.sendError(s, e2.getMessage());
                }
            }
        }
        MantisEvent mantisEvent = null;
        if (!matchingSubscriptions.isEmpty()) {
            mantisEvent = this.projectSupersetEvent(stream, matchingSubscriptions, event);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("no matching subscriptions");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exit EventProcessor#onNext: {}", (Object)event);
        }
        return mantisEvent;
    }

    void maskSensitiveFields(Event event) {
        String blacklistKeys = this.config.blackListedKeysCSV();
        List blacklist = Arrays.stream(blacklistKeys.split(",")).map(String::trim).collect(Collectors.toList());
        blacklist.stream().filter(key2 -> event.get((String)key2) != null).forEach(key2 -> event.set((String)key2, "***"));
    }

    private void sendError(Subscription subscription2, String errorMessage) {
    }

    private MantisEvent projectSupersetEvent(String streamName, List<Subscription> matchingSubscriptions, Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enter EventProcessor#projectSupersetEvent {}  event: {}", (Object)matchingSubscriptions, (Object)event);
        }
        Event projectedEvent = new Event();
        try {
            if (!matchingSubscriptions.isEmpty()) {
                projectedEvent = matchingSubscriptions.get(0).projectSuperset(matchingSubscriptions, event);
            }
        }
        catch (Exception e2) {
            if (this.errorLogEnabled.get()) {
                String queries = matchingSubscriptions.stream().map(Subscription::getRawQuery).collect(Collectors.joining(", "));
                LOG.error("Failed to project Event {} for queries: {}", (Object)event, (Object)queries);
                this.errorLogEnabled.set(false);
            }
            this.streamManager.getStreamMetrics(streamName).ifPresent(m -> m.getMantisQueryProjectionFailedCounter().increment());
        }
        MantisEvent augmentedMantisEvent = null;
        if (!projectedEvent.isEmpty()) {
            Event eventWithMatchedClients = this.enrich(projectedEvent, streamName, matchingSubscriptions);
            augmentedMantisEvent = new MantisEvent(1, eventWithMatchedClients.toJsonString());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Projected event is empty. skipping");
        }
        return augmentedMantisEvent;
    }

    private Event enrich(Event projectedEvent, String streamName, List<Subscription> matchingSubscriptions) {
        projectedEvent.set("type", "EVENT");
        projectedEvent.set("mantisStream", streamName);
        ArrayList<String> subIdList = new ArrayList<String>(matchingSubscriptions.size());
        for (Subscription res : matchingSubscriptions) {
            subIdList.add(res.getSubscriptionId());
        }
        projectedEvent.set("matched-clients", subIdList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated event string: {}", (Object)projectedEvent);
        }
        return projectedEvent;
    }
}

