/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class HttpUtils {
    static final byte[] EMPTY = new byte[0];
    private static final String DEFAULT = "default";
    private static final Pattern PREFIX = Pattern.compile("^([^.-]+).*$");

    private HttpUtils() {
    }

    static String clientNameForHost(String host) {
        Matcher m = PREFIX.matcher(host);
        return m.matches() ? m.group(1) : DEFAULT;
    }

    static String clientNameForURI(URI uri) {
        String host = uri.getHost();
        return host == null ? DEFAULT : HttpUtils.clientNameForHost(host);
    }

    static byte[] gzip(byte[] data2) throws IOException {
        return HttpUtils.gzip(data2, -1);
    }

    static byte[] gzip(byte[] data2, int level) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data2.length);
        try (GzipLevelOutputStream out = new GzipLevelOutputStream(baos);){
            out.setLevel(level);
            out.write(data2);
        }
        return baos.toByteArray();
    }

    static byte[] gunzip(byte[] data2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data2.length * 10);
        try (GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(data2));){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, length);
            }
        }
        return baos.toByteArray();
    }

    static class GzipLevelOutputStream
    extends GZIPOutputStream {
        GzipLevelOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        void setLevel(int level) {
            this.def.setLevel(level);
        }
    }
}

