/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import java.util.Objects;

public class ServerGroup {
    private final String asg;
    private final int d1;
    private final int d2;
    private final int dN;

    public static ServerGroup parse(String asg) {
        int d1 = asg.indexOf(45);
        int d2 = asg.indexOf(45, d1 + 1);
        int dN = asg.lastIndexOf(45);
        if (dN < 0 || !ServerGroup.isSequence(asg, dN)) {
            dN = asg.length();
        }
        return new ServerGroup(asg, d1, d2, dN);
    }

    private static boolean isSequence(String asg, int dN) {
        int length = asg.length();
        if (length - dN < 3 || asg.charAt(dN + 1) != 'v') {
            return false;
        }
        for (int i = dN + 2; i < length; ++i) {
            if (Character.isDigit(asg.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String substr(String str2, int s, int e2) {
        return s >= e2 ? null : str2.substring(s, e2);
    }

    ServerGroup(String asg, int d1, int d2, int dN) {
        this.asg = asg;
        this.d1 = d1;
        this.d2 = d2;
        this.dN = dN;
    }

    public String app() {
        if (this.d1 < 0) {
            return this.asg.length() > 0 ? this.asg : null;
        }
        if (this.d1 == 0) {
            return null;
        }
        return ServerGroup.substr(this.asg, 0, this.d1);
    }

    public String cluster() {
        if (this.d1 == 0) {
            return null;
        }
        return this.dN > 0 && this.dN == this.asg.length() ? this.asg() : ServerGroup.substr(this.asg, 0, this.dN);
    }

    public String asg() {
        return this.d1 != 0 && this.dN > 0 ? this.asg : null;
    }

    public String stack() {
        if (this.d1 <= 0) {
            return null;
        }
        if (this.d2 < 0) {
            return ServerGroup.substr(this.asg, this.d1 + 1, this.dN);
        }
        return ServerGroup.substr(this.asg, this.d1 + 1, this.d2);
    }

    public String detail() {
        return this.d1 != 0 && this.d2 > 0 ? ServerGroup.substr(this.asg, this.d2 + 1, this.dN) : null;
    }

    public String sequence() {
        return this.dN == this.asg.length() ? null : ServerGroup.substr(this.asg, this.dN + 1, this.asg.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerGroup that = (ServerGroup)o;
        return this.d1 == that.d1 && this.d2 == that.d2 && this.dN == that.dN && Objects.equals(this.asg, that.asg);
    }

    public int hashCode() {
        return Objects.hash(this.asg, this.d1, this.d2, this.dN);
    }

    public String toString() {
        return "ServerGroup(" + this.asg + ", " + this.d1 + ", " + this.d2 + ", " + this.dN + ")";
    }
}

