/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.CardinalityLimiters;
import com.netflix.spectator.ipc.IpcLogEntry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;

public class IpcLogger {
    private static final Marker CLIENT = MarkerFactory.getMarker("ipc-client");
    private static final Marker SERVER = MarkerFactory.getMarker("ipc-server");
    private final Registry registry;
    private final Clock clock;
    private final Logger logger;
    private final ConcurrentHashMap<Id, AtomicInteger> inflightRequests;
    private final ConcurrentHashMap<String, Function<String, String>> limiters;
    private final LinkedBlockingQueue<IpcLogEntry> entries;

    IpcLogger(Registry registry, Clock clock, Logger logger) {
        this.registry = registry;
        this.clock = clock;
        this.logger = logger;
        this.inflightRequests = new ConcurrentHashMap();
        this.limiters = new ConcurrentHashMap();
        this.entries = new LinkedBlockingQueue(1000);
    }

    public IpcLogger(Registry registry, Logger logger) {
        this(registry, Clock.SYSTEM, logger);
    }

    public IpcLogger(Registry registry) {
        this(registry, Clock.SYSTEM, LoggerFactory.getLogger(IpcLogger.class));
    }

    AtomicInteger inflightRequests(Id id) {
        return Utils.computeIfAbsent(this.inflightRequests, id, i -> new AtomicInteger());
    }

    Function<String, String> limiterForKey(String key2) {
        return Utils.computeIfAbsent(this.limiters, key2, k -> CardinalityLimiters.mostFrequent(10));
    }

    private IpcLogEntry newEntry() {
        IpcLogEntry entry = this.entries.poll();
        return entry == null ? new IpcLogEntry(this.clock) : entry;
    }

    public IpcLogEntry createClientEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(CLIENT);
    }

    public IpcLogEntry createServerEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(SERVER);
    }

    void log(IpcLogEntry entry) {
        BiConsumer<Marker, String> log2;
        Predicate<Marker> enabled;
        Level level = entry.getLevel();
        switch (level) {
            case TRACE: {
                enabled = this.logger::isTraceEnabled;
                log2 = this.logger::trace;
                break;
            }
            case DEBUG: {
                enabled = this.logger::isDebugEnabled;
                log2 = this.logger::debug;
                break;
            }
            case INFO: {
                enabled = this.logger::isInfoEnabled;
                log2 = this.logger::info;
                break;
            }
            case WARN: {
                enabled = this.logger::isWarnEnabled;
                log2 = this.logger::warn;
                break;
            }
            case ERROR: {
                enabled = this.logger::isErrorEnabled;
                log2 = this.logger::error;
                break;
            }
            default: {
                enabled = this.logger::isDebugEnabled;
                log2 = this.logger::debug;
            }
        }
        if (enabled.test(entry.getMarker())) {
            log2.accept(entry.getMarker(), entry.toString());
        }
        if (entry.isSuccessful()) {
            entry.reset();
            this.entries.offer(entry);
        } else {
            entry.resetForRetry();
        }
    }
}

