/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.matcher.GreedyMatcher;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.SeqMatcher;
import com.netflix.spectator.impl.matcher.TrueMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class OrMatcher
implements GreedyMatcher {
    private final Matcher[] matchers;
    private final int minLength;

    static Matcher create(List<Matcher> matchers) {
        return OrMatcher.create(matchers.toArray(new Matcher[0]));
    }

    static Matcher create(Matcher ... matchers) {
        switch (matchers.length) {
            case 0: {
                return TrueMatcher.INSTANCE;
            }
            case 1: {
                return matchers[0];
            }
        }
        return new OrMatcher(matchers);
    }

    OrMatcher(Matcher ... matchers) {
        this.matchers = matchers;
        int min2 = Integer.MAX_VALUE;
        for (Matcher matcher : matchers) {
            min2 = Math.min(min2, matcher.minLength());
        }
        this.minLength = min2;
    }

    List<Matcher> matchers() {
        return Arrays.asList(this.matchers);
    }

    @Override
    public int matches(String str2, int start, int length) {
        for (Matcher matcher : this.matchers) {
            int pos = matcher.matches(str2, start, length);
            if (pos < 0) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public int minLength() {
        return this.minLength;
    }

    @Override
    public boolean isStartAnchored() {
        boolean anchored = true;
        for (Matcher m : this.matchers) {
            anchored &= m.isStartAnchored();
        }
        return anchored;
    }

    @Override
    public boolean isEndAnchored() {
        boolean anchored = true;
        for (Matcher m : this.matchers) {
            anchored &= m.isEndAnchored();
        }
        return anchored;
    }

    @Override
    public Matcher mergeNext(Matcher after) {
        if (after instanceof TrueMatcher) {
            return this;
        }
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        for (Matcher m : this.matchers) {
            ms.add(SeqMatcher.create(m, after));
        }
        return OrMatcher.create(ms);
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        for (Matcher m : this.matchers) {
            ms.add(m.rewrite(f));
        }
        return f.apply(OrMatcher.create(ms));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        for (Matcher m : this.matchers) {
            ms.add(m.rewriteEnd(f));
        }
        return f.apply(OrMatcher.create(ms));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < this.matchers.length; ++i) {
            if (i > 0) {
                builder.append('|');
            }
            builder.append(this.matchers[i].toString());
        }
        builder.append(')');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrMatcher orMatcher = (OrMatcher)o;
        return this.minLength == orMatcher.minLength && Arrays.equals(this.matchers, orMatcher.matchers);
    }

    public int hashCode() {
        int result = Objects.hash(this.minLength);
        result = 31 * result + Arrays.hashCode(this.matchers);
        return result;
    }
}

