/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.matcher.EndMatcher;
import com.netflix.spectator.impl.matcher.GreedyMatcher;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.PatternUtils;
import com.netflix.spectator.impl.matcher.SeqMatcher;
import com.netflix.spectator.impl.matcher.TrueMatcher;
import java.util.Objects;
import java.util.function.Function;

final class IndexOfMatcher
implements GreedyMatcher {
    private final String pattern;
    private final Matcher next;
    private final boolean ignoreCase;

    IndexOfMatcher(String pattern, Matcher next2) {
        this(pattern, next2, false);
    }

    IndexOfMatcher(String pattern, Matcher next2, boolean ignoreCase) {
        this.pattern = pattern;
        this.next = next2;
        this.ignoreCase = ignoreCase;
    }

    String pattern() {
        return this.pattern;
    }

    Matcher next() {
        return this.next;
    }

    private int indexOfIgnoreCase(String str2, int offset) {
        int length = this.pattern.length();
        int end = str2.length() - length + 1;
        for (int i = offset; i < end; ++i) {
            if (!str2.regionMatches(true, i, this.pattern, 0, length)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(String str2, int offset) {
        return this.ignoreCase ? this.indexOfIgnoreCase(str2, offset) : str2.indexOf(this.pattern, offset);
    }

    private boolean endsWithIgnoreCase(String str2) {
        int length = this.pattern.length();
        int offset = str2.length() - length;
        return str2.regionMatches(true, offset, this.pattern, 0, length);
    }

    private boolean endsWith(String str2, int offset) {
        int length;
        int remaining = str2.length() - offset;
        if (remaining < (length = this.pattern.length())) {
            return false;
        }
        return this.ignoreCase ? this.endsWithIgnoreCase(str2) : str2.endsWith(this.pattern);
    }

    @Override
    public int matches(String str2, int start, int length) {
        if (this.next == TrueMatcher.INSTANCE) {
            int pos = this.indexOf(str2, start);
            return pos >= 0 ? pos + this.pattern.length() : -1;
        }
        if (this.next == EndMatcher.INSTANCE) {
            return this.endsWith(str2, start) ? length : -1;
        }
        int end = start + length;
        int stop = end - this.next.minLength();
        int pos = start;
        while (pos >= 0 && pos <= stop) {
            if ((pos = this.indexOf(str2, pos)) < 0) continue;
            int s = pos + this.pattern.length();
            int p = this.next.matches(str2, s, end - s);
            if (p >= 0) {
                return p;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public int minLength() {
        return this.pattern.length() + this.next.minLength();
    }

    @Override
    public boolean isEndAnchored() {
        return this.next.isEndAnchored();
    }

    @Override
    public Matcher mergeNext(Matcher after) {
        if (after instanceof TrueMatcher) {
            return this;
        }
        Matcher m = this.next instanceof TrueMatcher ? after : SeqMatcher.create(this.next, after);
        return new IndexOfMatcher(this.pattern, m);
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        return f.apply(new IndexOfMatcher(this.pattern, this.next.rewrite(f)));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return f.apply(new IndexOfMatcher(this.pattern, this.next.rewriteEnd(f)));
    }

    public String toString() {
        return ".*" + PatternUtils.escape(this.pattern) + this.next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexOfMatcher that = (IndexOfMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.next, this.ignoreCase);
    }
}

