/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.PatternUtils;
import java.util.Objects;

final class CharSeqMatcher
implements Matcher {
    private final String pattern;
    private final boolean ignoreCase;

    CharSeqMatcher(char pattern) {
        this(String.valueOf(pattern));
    }

    CharSeqMatcher(String pattern) {
        this(pattern, false);
    }

    CharSeqMatcher(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    String pattern() {
        return this.pattern;
    }

    @Override
    public int matches(String str2, int start, int length) {
        int plength = this.pattern.length();
        boolean matched = this.ignoreCase ? str2.regionMatches(true, start, this.pattern, 0, plength) : str2.startsWith(this.pattern, start);
        return matched ? start + plength : -1;
    }

    @Override
    public int minLength() {
        return this.pattern.length();
    }

    public String toString() {
        return PatternUtils.escape(this.pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharSeqMatcher that = (CharSeqMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.ignoreCase);
    }
}

