/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.AsciiSet;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.PatternUtils;
import java.util.Objects;

final class CharClassMatcher
implements Matcher {
    private final AsciiSet set;
    private final boolean ignoreCase;

    CharClassMatcher(AsciiSet set2) {
        this(set2, false);
    }

    CharClassMatcher(AsciiSet set2, boolean ignoreCase) {
        this.set = set2;
        this.ignoreCase = ignoreCase;
    }

    AsciiSet set() {
        return this.set;
    }

    private char toOtherCase(char c) {
        int amount = 32;
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 32);
        }
        return c;
    }

    @Override
    public int matches(String str2, int start, int length) {
        if (length > 0) {
            char c = str2.charAt(start);
            boolean matched = this.ignoreCase ? this.set.contains(c) || this.set.contains(this.toOtherCase(c)) : this.set.contains(c);
            return matched ? start + 1 : -1;
        }
        return -1;
    }

    @Override
    public int minLength() {
        return 1;
    }

    public String toString() {
        String p = this.set.toString();
        String n = this.set.invert().toString();
        String str2 = p.length() < n.length() || n.isEmpty() ? PatternUtils.escape(p) : "^" + PatternUtils.escape(n);
        return "[" + str2 + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharClassMatcher that = (CharClassMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.set, that.set);
    }

    public int hashCode() {
        return Objects.hash(this.set, this.ignoreCase);
    }
}

