/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.patterns;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.GaugePoller;
import com.netflix.spectator.api.patterns.IdBuilder;
import com.netflix.spectator.api.patterns.TagsBuilder;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolledMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolledMeter.class);

    private PolledMeter() {
    }

    public static IdBuilder<Builder> using(Registry registry) {
        return new IdBuilder<Builder>(registry){

            @Override
            protected Builder createTypeBuilder(Id id) {
                return new Builder(this.registry, id);
            }
        };
    }

    public static void update(Registry registry) {
        Iterator iter = registry.state().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof AbstractMeterState)) continue;
            AbstractMeterState tuple = (AbstractMeterState)entry.getValue();
            tuple.doUpdate(registry);
            if (!tuple.hasExpired()) continue;
            iter.remove();
        }
    }

    public static void remove(Registry registry, Id id) {
        Object obj = registry.state().get(id);
        if (obj instanceof AbstractMeterState) {
            registry.state().remove(id, obj);
        }
    }

    @Deprecated
    public static void monitorMeter(Registry registry, Meter meter) {
        ConcurrentMap<Id, Object> state = registry.state();
        Object c = Utils.computeIfAbsent(state, meter.id(), MeterState::new);
        if (!(c instanceof MeterState)) {
            Utils.propagateTypeError(registry, meter.id(), MeterState.class, c.getClass());
        } else {
            MeterState t = (MeterState)c;
            t.add(meter);
            long delay2 = registry.config().gaugePollingFrequency().toMillis();
            t.schedule(registry, null, delay2);
        }
    }

    static final class CounterEntry<T> {
        private final WeakReference<T> ref;
        private final ToLongFunction<T> f;
        private long previous;

        CounterEntry(T obj, ToLongFunction<T> f) {
            this.ref = new WeakReference<T>(obj);
            this.f = f;
            this.previous = f.applyAsLong(obj);
        }

        private void update(Counter counter) {
            Object obj = this.ref.get();
            if (obj != null) {
                long current = this.f.applyAsLong(obj);
                if (current > this.previous) {
                    long delta = current - this.previous;
                    LOGGER.trace("incrementing counter [{}] by {}", (Object)counter.id(), (Object)delta);
                    counter.increment(delta);
                } else {
                    LOGGER.trace("no update to counter [{}]: previous = {}, current = {}", counter.id(), this.previous, current);
                }
                this.previous = current;
            }
        }
    }

    static final class CounterState<T>
    extends AbstractMeterState {
        private final Counter counter;
        private final ConcurrentLinkedQueue<CounterEntry<T>> entries;

        CounterState(Counter counter) {
            this.counter = counter;
            this.entries = new ConcurrentLinkedQueue();
        }

        private void add(T obj, ToLongFunction<T> f) {
            this.entries.add(new CounterEntry<T>(obj, f));
        }

        @Override
        protected Id id() {
            return this.counter.id();
        }

        @Override
        protected boolean hasExpired() {
            return this.entries.isEmpty();
        }

        @Override
        protected void update(Registry registry) {
            Iterator<CounterEntry<T>> iter = this.entries.iterator();
            while (iter.hasNext()) {
                CounterEntry<T> state = iter.next();
                if (((CounterEntry)state).ref.get() == null) {
                    iter.remove();
                    continue;
                }
                ((CounterEntry)state).update(this.counter);
            }
            if (this.entries.isEmpty()) {
                LOGGER.trace("monotonic counter [{}] has expired", (Object)this.id());
            }
        }
    }

    static final class MeterState
    extends AbstractMeterState {
        private final Id id;
        private final ConcurrentLinkedQueue<Meter> queue;

        MeterState(Id id) {
            this.id = id;
            this.queue = new ConcurrentLinkedQueue();
        }

        void add(Meter m) {
            this.queue.add(m);
        }

        @Override
        protected Id id() {
            return this.id;
        }

        @Override
        protected boolean hasExpired() {
            return this.queue.isEmpty();
        }

        private Iterable<Measurement> measure() {
            HashMap<Id, Measurement> measurements = new HashMap<Id, Measurement>();
            Iterator<Meter> iter = this.queue.iterator();
            while (iter.hasNext()) {
                Meter meter = iter.next();
                if (meter.hasExpired()) {
                    iter.remove();
                    continue;
                }
                for (Measurement m : meter.measure()) {
                    Measurement prev2 = (Measurement)measurements.get(m.id());
                    if (prev2 == null) {
                        measurements.put(m.id(), m);
                        continue;
                    }
                    double v = prev2.value() + m.value();
                    measurements.put(prev2.id(), new Measurement(prev2.id(), prev2.timestamp(), v));
                }
            }
            if (this.queue.isEmpty()) {
                LOGGER.trace("meter [{}] has expired", (Object)this.id);
            }
            return measurements.values();
        }

        @Override
        protected void update(Registry registry) {
            for (Measurement m : this.measure()) {
                LOGGER.trace("setting gauge [{}] to {}", (Object)m.id(), (Object)m.value());
                registry.gauge(m.id()).set(m.value());
            }
        }
    }

    static final class ValueEntry<T> {
        private final WeakReference<T> ref;
        private final ToDoubleFunction<T> f;

        ValueEntry(T obj, ToDoubleFunction<T> f) {
            this.ref = new WeakReference<T>(obj);
            this.f = f;
        }
    }

    static final class ValueState<T>
    extends AbstractMeterState {
        private final Gauge gauge;
        private final ConcurrentLinkedQueue<ValueEntry<T>> pairs;

        ValueState(Gauge gauge) {
            this.gauge = gauge;
            this.pairs = new ConcurrentLinkedQueue();
        }

        private void add(T obj, ToDoubleFunction<T> f) {
            this.pairs.add(new ValueEntry<T>(obj, f));
        }

        @Override
        protected Id id() {
            return this.gauge.id();
        }

        @Override
        protected boolean hasExpired() {
            return this.pairs.isEmpty();
        }

        @Override
        protected void update(Registry registry) {
            double sum = Double.NaN;
            Iterator<ValueEntry<T>> iter = this.pairs.iterator();
            while (iter.hasNext()) {
                ValueEntry<T> pair = iter.next();
                Object obj = ((ValueEntry)pair).ref.get();
                if (obj != null) {
                    double v = ((ValueEntry)pair).f.applyAsDouble(obj);
                    if (Double.isNaN(v)) continue;
                    sum = Double.isNaN(sum) ? v : sum + v;
                    continue;
                }
                iter.remove();
            }
            if (this.pairs.isEmpty()) {
                LOGGER.trace("gauge [{}] has expired", (Object)this.gauge.id());
            }
            LOGGER.trace("setting gauge [{}] to {}", (Object)this.gauge.id(), (Object)sum);
            this.gauge.set(sum);
        }
    }

    static abstract class AbstractMeterState {
        private boolean scheduled = false;

        AbstractMeterState() {
        }

        protected abstract Id id();

        protected abstract boolean hasExpired();

        protected abstract void update(Registry var1);

        void doUpdate(Registry registry) {
            if (this.hasExpired()) {
                registry.state().remove(this.id());
            } else {
                try {
                    this.update(registry);
                }
                catch (Throwable t) {
                    LOGGER.trace("uncaught exception from gauge function for [{}]", (Object)this.id(), (Object)t);
                    throw t;
                }
            }
        }

        void schedule(Registry registry, ScheduledExecutorService executor, long delay2) {
            if (!this.scheduled) {
                WeakReference<AbstractMeterState> tupleRef = new WeakReference<AbstractMeterState>(this);
                if (executor == null) {
                    GaugePoller.schedule(tupleRef, delay2, t -> t.doUpdate(registry));
                } else {
                    GaugePoller.schedule(executor, tupleRef, delay2, t -> t.doUpdate(registry));
                }
                this.scheduled = true;
            }
        }
    }

    public static final class Builder
    extends TagsBuilder<Builder> {
        private final Registry registry;
        private final Id baseId;
        private ScheduledExecutorService executor;
        private long delay;

        Builder(Registry registry, Id baseId) {
            this.registry = registry;
            this.baseId = baseId;
            this.delay = registry.config().gaugePollingFrequency().toMillis();
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withDelay(Duration delay2) {
            this.delay = delay2.toMillis();
            return this;
        }

        public <T extends Number> T monitorValue(T number) {
            return (T)this.monitorValue(number, Number::doubleValue);
        }

        public <T> T monitorValue(T obj, ToDoubleFunction<T> f) {
            Id id = this.baseId.withTags(this.extraTags);
            Gauge gauge = this.registry.gauge(id);
            ValueState tuple = new ValueState(gauge);
            ConcurrentMap<Id, Object> state = this.registry.state();
            Object c = Utils.computeIfAbsent(state, id, i -> tuple);
            if (!(c instanceof ValueState)) {
                Utils.propagateTypeError(this.registry, id, PolledMeter.class, c.getClass());
            } else {
                ValueState t = (ValueState)c;
                t.add(obj, f);
                t.schedule(this.registry, this.executor, this.delay);
            }
            return obj;
        }

        public <T extends Number> T monitorMonotonicCounter(T number) {
            return (T)this.monitorMonotonicCounter(number, Number::longValue);
        }

        public <T> T monitorMonotonicCounter(T obj, ToLongFunction<T> f) {
            Id id = this.baseId.withTags(this.extraTags);
            Counter counter = this.registry.counter(id);
            CounterState tuple = new CounterState(counter);
            ConcurrentMap<Id, Object> state = this.registry.state();
            Object c = Utils.computeIfAbsent(state, id, i -> tuple);
            if (!(c instanceof CounterState)) {
                Utils.propagateTypeError(this.registry, id, PolledMeter.class, c.getClass());
            } else {
                CounterState t = (CounterState)c;
                t.add(obj, f);
                t.schedule(this.registry, this.executor, this.delay);
            }
            return obj;
        }

        public <T extends Collection<?>> T monitorSize(T collection) {
            return (T)this.monitorValue(collection, Collection::size);
        }

        public <T extends Map<?, ?>> T monitorSize(T map2) {
            return (T)this.monitorValue(map2, Map::size);
        }
    }
}

