/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.impl.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Function;

public final class PercentileBuckets {
    private static final int DIGITS = 2;
    private static final long[] BUCKET_VALUES;
    private static final int[] POWER_OF_4_INDEX;

    private PercentileBuckets() {
    }

    public static long[] asArray() {
        long[] values = new long[BUCKET_VALUES.length];
        System.arraycopy(BUCKET_VALUES, 0, values, 0, BUCKET_VALUES.length);
        return values;
    }

    public static <T> T[] map(Class<T> c, Function<Long, T> f) {
        Object[] values = (Object[])Array.newInstance(c, BUCKET_VALUES.length);
        for (int i = 0; i < BUCKET_VALUES.length; ++i) {
            values[i] = f.apply(BUCKET_VALUES[i]);
        }
        return values;
    }

    public static long get(int i) {
        return BUCKET_VALUES[i];
    }

    public static int length() {
        return BUCKET_VALUES.length;
    }

    public static int indexOf(long v) {
        long delta;
        long base;
        int offset;
        int pos;
        long prevPowerOf2;
        if (v <= 0L) {
            return 0;
        }
        if (v <= 4L) {
            return (int)v;
        }
        int lz = Long.numberOfLeadingZeros(v);
        int shift = 64 - lz - 1;
        long prevPowerOf4 = prevPowerOf2 = v >> shift << shift;
        if (shift % 2 != 0) {
            --shift;
            prevPowerOf4 = prevPowerOf2 >> 1;
        }
        return (pos = (offset = (int)((v - (base = prevPowerOf4)) / (delta = base / 3L))) + POWER_OF_4_INDEX[shift / 2]) >= BUCKET_VALUES.length - 1 ? BUCKET_VALUES.length - 1 : pos + 1;
    }

    public static long bucket(long v) {
        return BUCKET_VALUES[PercentileBuckets.indexOf(v)];
    }

    public static void percentiles(long[] counts, double[] pcts, double[] results) {
        Preconditions.checkArg(counts.length == BUCKET_VALUES.length, "counts is not the same size as buckets array");
        Preconditions.checkArg(pcts.length > 0, "pct array cannot be empty");
        Preconditions.checkArg(pcts.length == results.length, "pcts is not the same size as results array");
        long total = 0L;
        for (long c : counts) {
            total += c;
        }
        int pctIdx = 0;
        long prev2 = 0L;
        double prevP = 0.0;
        long prevB = 0L;
        for (int i = 0; i < BUCKET_VALUES.length; ++i) {
            long next2 = prev2 + counts[i];
            double nextP = 100.0 * (double)next2 / (double)total;
            long nextB = BUCKET_VALUES[i];
            while (pctIdx < pcts.length && nextP >= pcts[pctIdx]) {
                double f = (pcts[pctIdx] - prevP) / (nextP - prevP);
                results[pctIdx] = f * (double)(nextB - prevB) + (double)prevB;
                ++pctIdx;
            }
            if (pctIdx >= pcts.length) break;
            prev2 = next2;
            prevP = nextP;
            prevB = nextB;
        }
        double nextP = 100.0;
        long nextB = Long.MAX_VALUE;
        while (pctIdx < pcts.length) {
            double f = (pcts[pctIdx] - prevP) / (nextP - prevP);
            results[pctIdx] = f * (double)(nextB - prevB) + (double)prevB;
            ++pctIdx;
        }
    }

    public static double percentile(long[] counts, double p) {
        double[] pcts = new double[]{p};
        double[] results = new double[1];
        PercentileBuckets.percentiles(counts, pcts, results);
        return results[0];
    }

    static {
        int i;
        ArrayList<Integer> powerOf4Index = new ArrayList<Integer>();
        powerOf4Index.add(0);
        ArrayList<Long> buckets = new ArrayList<Long>();
        buckets.add(1L);
        buckets.add(2L);
        buckets.add(3L);
        for (int exp = 2; exp < 64; exp += 2) {
            long current;
            long delta = current / 3L;
            long next2 = (current << 2) - delta;
            powerOf4Index.add(buckets.size());
            for (current = 1L << exp; current < next2; current += delta) {
                buckets.add(current);
            }
        }
        buckets.add(Long.MAX_VALUE);
        BUCKET_VALUES = new long[buckets.size()];
        for (i = 0; i < buckets.size(); ++i) {
            PercentileBuckets.BUCKET_VALUES[i] = (Long)buckets.get(i);
        }
        POWER_OF_4_INDEX = new int[powerOf4Index.size()];
        for (i = 0; i < powerOf4Index.size(); ++i) {
            PercentileBuckets.POWER_OF_4_INDEX[i] = (Integer)powerOf4Index.get(i);
        }
    }
}

