/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;

public final class BucketTimer
implements Timer {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;

    public static BucketTimer get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketTimer(registry, id, f);
    }

    BucketTimer(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = unit.toNanos(amount);
        this.timer(this.f.apply(nanos)).record(amount, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> rf) throws Exception {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            T t = rf.call();
            return t;
        }
        finally {
            long e2 = clock.monotonicTime();
            this.record(e2 - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable rf) {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            rf.run();
        }
        finally {
            long e2 = clock.monotonicTime();
            this.record(e2 - s, TimeUnit.NANOSECONDS);
        }
    }

    Timer timer(String bucket) {
        return this.registry.timer(this.id.withTag("bucket", bucket));
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalTime() {
        return 0L;
    }
}

