/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Functions;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.impl.Config;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.LoggerFactory;

public interface Registry
extends Iterable<Meter> {
    public Clock clock();

    default public RegistryConfig config() {
        return Config.defaultConfig();
    }

    public Id createId(String var1);

    public Id createId(String var1, Iterable<Tag> var2);

    public void register(Meter var1);

    public ConcurrentMap<Id, Object> state();

    public Counter counter(Id var1);

    public DistributionSummary distributionSummary(Id var1);

    public Timer timer(Id var1);

    public Gauge gauge(Id var1);

    public Gauge maxGauge(Id var1);

    public Meter get(Id var1);

    @Override
    public Iterator<Meter> iterator();

    default public <T extends Registry> T underlying(Class<T> c) {
        if (c.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this instanceof CompositeRegistry) {
            return ((CompositeRegistry)this).find(c);
        }
        return null;
    }

    default public Id createId(String name2, String ... tags) {
        return this.createId(name2, Utils.toIterable(tags));
    }

    default public Id createId(String name2, Map<String, String> tags) {
        return this.createId(name2).withTags(tags);
    }

    default public Counter counter(String name2) {
        return this.counter(this.createId(name2));
    }

    default public Counter counter(String name2, Iterable<Tag> tags) {
        return this.counter(this.createId(name2, tags));
    }

    default public Counter counter(String name2, String ... tags) {
        return this.counter(this.createId(name2, Utils.toIterable(tags)));
    }

    default public DistributionSummary distributionSummary(String name2) {
        return this.distributionSummary(this.createId(name2));
    }

    default public DistributionSummary distributionSummary(String name2, Iterable<Tag> tags) {
        return this.distributionSummary(this.createId(name2, tags));
    }

    default public DistributionSummary distributionSummary(String name2, String ... tags) {
        return this.distributionSummary(this.createId(name2, Utils.toIterable(tags)));
    }

    default public Timer timer(String name2) {
        return this.timer(this.createId(name2));
    }

    default public Timer timer(String name2, Iterable<Tag> tags) {
        return this.timer(this.createId(name2, tags));
    }

    default public Timer timer(String name2, String ... tags) {
        return this.timer(this.createId(name2, Utils.toIterable(tags)));
    }

    default public Gauge gauge(String name2) {
        return this.gauge(this.createId(name2));
    }

    default public Gauge gauge(String name2, Iterable<Tag> tags) {
        return this.gauge(this.createId(name2, tags));
    }

    default public Gauge gauge(String name2, String ... tags) {
        return this.gauge(this.createId(name2, Utils.toIterable(tags)));
    }

    default public Gauge maxGauge(String name2) {
        return this.maxGauge(this.createId(name2));
    }

    default public Gauge maxGauge(String name2, Iterable<Tag> tags) {
        return this.maxGauge(this.createId(name2, tags));
    }

    default public Gauge maxGauge(String name2, String ... tags) {
        return this.maxGauge(this.createId(name2, Utils.toIterable(tags)));
    }

    @Deprecated
    default public LongTaskTimer longTaskTimer(Id id) {
        return com.netflix.spectator.api.patterns.LongTaskTimer.get(this, id);
    }

    @Deprecated
    default public LongTaskTimer longTaskTimer(String name2) {
        return this.longTaskTimer(this.createId(name2));
    }

    @Deprecated
    default public LongTaskTimer longTaskTimer(String name2, Iterable<Tag> tags) {
        return this.longTaskTimer(this.createId(name2, tags));
    }

    @Deprecated
    default public LongTaskTimer longTaskTimer(String name2, String ... tags) {
        return this.longTaskTimer(this.createId(name2, Utils.toIterable(tags)));
    }

    @Deprecated
    default public <T extends Number> T gauge(Id id, T number) {
        return PolledMeter.using(this).withId(id).monitorValue(number);
    }

    @Deprecated
    default public <T extends Number> T gauge(String name2, T number) {
        return this.gauge(this.createId(name2), number);
    }

    @Deprecated
    default public <T extends Number> T gauge(String name2, Iterable<Tag> tags, T number) {
        return this.gauge(this.createId(name2, tags), number);
    }

    @Deprecated
    default public <T> T gauge(Id id, T obj, ToDoubleFunction<T> f) {
        return PolledMeter.using(this).withId(id).monitorValue(obj, f);
    }

    @Deprecated
    default public <T> T gauge(String name2, T obj, ToDoubleFunction<T> f) {
        return this.gauge(this.createId(name2), obj, f);
    }

    @Deprecated
    default public <T extends Collection<?>> T collectionSize(Id id, T collection) {
        return PolledMeter.using(this).withId(id).monitorSize(collection);
    }

    @Deprecated
    default public <T extends Collection<?>> T collectionSize(String name2, T collection) {
        return this.collectionSize(this.createId(name2), collection);
    }

    @Deprecated
    default public <T extends Map<?, ?>> T mapSize(Id id, T collection) {
        return PolledMeter.using(this).withId(id).monitorSize(collection);
    }

    @Deprecated
    default public <T extends Map<?, ?>> T mapSize(String name2, T collection) {
        return this.mapSize(this.createId(name2), collection);
    }

    @Deprecated
    default public void methodValue(Id id, Object obj, String method) {
        Method m = Utils.getGaugeMethod(this, id, obj, method);
        if (m != null) {
            PolledMeter.using(this).withId(id).monitorValue(obj, Functions.invokeMethod(m));
        }
    }

    @Deprecated
    default public void methodValue(String name2, Object obj, String method) {
        this.methodValue(this.createId(name2), obj, method);
    }

    default public Stream<Meter> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<Counter> counters() {
        return this.stream().filter(m -> m instanceof Counter).map(m -> (Counter)m);
    }

    default public Stream<DistributionSummary> distributionSummaries() {
        return this.stream().filter(m -> m instanceof DistributionSummary).map(m -> (DistributionSummary)m);
    }

    default public Stream<Timer> timers() {
        return this.stream().filter(m -> m instanceof Timer).map(m -> (Timer)m);
    }

    default public Stream<Gauge> gauges() {
        return this.stream().filter(m -> m instanceof Gauge).map(m -> (Gauge)m);
    }

    default public void propagate(String msg, Throwable t) {
        LoggerFactory.getLogger(this.getClass()).warn(msg, t);
        if (this.config().propagateWarnings()) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    default public void propagate(Throwable t) {
        this.propagate(t.getMessage(), t);
    }
}

