/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DoubleFunction;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.impl.Preconditions;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);
    public static final DoubleFunction<? extends Number> IDENTITY = new DoubleFunction<Number>(){

        @Override
        public double apply(double v) {
            return v;
        }
    };
    public static final DoubleFunction<AtomicLong> AGE = Functions.age(Clock.SYSTEM);

    private Functions() {
    }

    public static DoubleFunction<AtomicLong> age(final Clock clock) {
        return new DoubleFunction<AtomicLong>(){

            @Override
            public double apply(double t) {
                return ((double)clock.wallTime() - t) / 1000.0;
            }
        };
    }

    public static <T> ToDoubleFunction<T> invokeMethod(Method method) {
        method.setAccessible(true);
        return obj -> {
            try {
                Number n = (Number)method.invoke(obj, new Object[0]);
                return n.doubleValue();
            }
            catch (Exception e2) {
                LOGGER.warn("exception from method registered as a gauge [" + method + "]", e2);
                return Double.NaN;
            }
        };
    }

    public static Predicate<Meter> nameEquals(String name2) {
        Preconditions.checkNotNull(name2, "name");
        return m -> name2.equals(m.id().name());
    }
}

