/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class DefaultId
implements Id {
    private final String name;
    private final ArrayTagSet tags;

    DefaultId(String name2) {
        this(name2, ArrayTagSet.EMPTY);
    }

    DefaultId(String name2, ArrayTagSet tags) {
        this.name = Preconditions.checkNotNull(name2, "name");
        this.tags = Preconditions.checkNotNull(tags, "tags");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<Tag> tags() {
        return this.tags;
    }

    @Override
    public DefaultId withTag(Tag tag) {
        return new DefaultId(this.name, this.tags.add(tag));
    }

    @Override
    public DefaultId withTag(String key2, String value) {
        return new DefaultId(this.name, this.tags.add(key2, value));
    }

    @Override
    public DefaultId withTags(String ... ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Tag ... ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Iterable<Tag> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Map<String, String> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    DefaultId normalize() {
        return this.rollup(Collections.emptySet(), false);
    }

    DefaultId rollup(Set<String> keys2, boolean keep2) {
        if (this.tags.isEmpty()) {
            return this;
        }
        TreeMap<String, String> ts = new TreeMap<String, String>();
        for (Tag t : this.tags) {
            if (keys2.contains(t.key()) != keep2 || ts.containsKey(t.key())) continue;
            ts.put(t.key(), t.value());
        }
        return new DefaultId(this.name, ArrayTagSet.create(ts));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultId)) {
            return false;
        }
        DefaultId other = (DefaultId)obj;
        return this.name.equals(other.name) && this.tags.equals(other.tags);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public String toString() {
        return this.name + this.tags;
    }
}

