/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class ArrayTagSet
implements Iterable<Tag> {
    private static final Comparator<Tag> TAG_COMPARATOR = (t1, t2) -> t1.key().compareTo(t2.key());
    static final ArrayTagSet EMPTY = new ArrayTagSet(new String[0]);
    private final String[] tags;
    private final int length;
    private int cachedHashCode;

    static ArrayTagSet create(String ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Tag ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Iterable<Tag> tags) {
        return tags instanceof ArrayTagSet ? (ArrayTagSet)tags : EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Map<String, String> tags) {
        return EMPTY.addAll(tags);
    }

    private ArrayTagSet(String[] tags) {
        this(tags, tags.length);
    }

    private ArrayTagSet(String[] tags, int length) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("length of tags array must be even");
        }
        if (length > tags.length) {
            throw new IllegalArgumentException("length cannot be larger than tags array");
        }
        this.tags = tags;
        this.length = length;
        this.cachedHashCode = 0;
    }

    @Override
    public Iterator<Tag> iterator() {
        return new Iterator<Tag>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArrayTagSet.this.length;
            }

            @Override
            public Tag next() {
                if (this.i >= ArrayTagSet.this.length) {
                    throw new NoSuchElementException("next called after end of iterator");
                }
                String k = ArrayTagSet.this.tags[this.i++];
                String v = ArrayTagSet.this.tags[this.i++];
                return new BasicTag(k, v);
            }
        };
    }

    boolean isEmpty() {
        return this.length == 0;
    }

    ArrayTagSet add(String k, String v) {
        return this.add(new BasicTag(k, v));
    }

    ArrayTagSet add(Tag tag) {
        int i;
        if (this.length == 0) {
            return new ArrayTagSet(new String[]{tag.key(), tag.value()});
        }
        String[] newTags = new String[this.length + 2];
        String k = tag.key();
        for (i = 0; i < this.length && this.tags[i].compareTo(k) < 0; i += 2) {
            newTags[i] = this.tags[i];
            newTags[i + 1] = this.tags[i + 1];
        }
        if (i < this.length && this.tags[i].equals(k)) {
            newTags[i++] = tag.key();
            newTags[i++] = tag.value();
            System.arraycopy(this.tags, i, newTags, i, this.length - i);
            i = this.length;
        } else {
            newTags[i] = tag.key();
            newTags[i + 1] = tag.value();
            System.arraycopy(this.tags, i, newTags, i + 2, this.length - i);
            i = newTags.length;
        }
        return new ArrayTagSet(newTags, i);
    }

    ArrayTagSet addAll(Iterable<Tag> ts) {
        if (ts instanceof Collection) {
            Collection data2 = (Collection)ts;
            if (data2.isEmpty()) {
                return this;
            }
            Tag[] newTags = new Tag[data2.size()];
            int i = 0;
            for (Tag t : data2) {
                newTags[i] = BasicTag.convert(t);
                ++i;
            }
            return this.addAll(newTags);
        }
        ArrayList<Tag> data3 = new ArrayList<Tag>();
        for (Tag t : ts) {
            data3.add(t);
        }
        return this.addAll(data3);
    }

    ArrayTagSet addAll(Map<String, String> ts) {
        if (ts.isEmpty()) {
            return this;
        }
        Tag[] newTags = new Tag[ts.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : ts.entrySet()) {
            newTags[i++] = new BasicTag(entry.getKey(), entry.getValue());
        }
        return this.addAll(newTags);
    }

    ArrayTagSet addAll(String[] ts) {
        if (ts.length % 2 != 0) {
            throw new IllegalArgumentException("array length must be even, (length=" + ts.length + ")");
        }
        if (ts.length == 0) {
            return this;
        }
        int tsLength = ts.length / 2;
        Tag[] newTags = new Tag[tsLength];
        for (int i = 0; i < tsLength; ++i) {
            int j = i * 2;
            newTags[i] = new BasicTag(ts[j], ts[j + 1]);
        }
        return this.addAll(newTags, tsLength);
    }

    ArrayTagSet addAll(Tag[] ts) {
        return this.addAll(ts, ts.length);
    }

    ArrayTagSet addAll(Tag[] ts, int tsLength) {
        if (tsLength == 0) {
            return this;
        }
        if (this.length == 0) {
            Arrays.sort(ts, 0, tsLength, TAG_COMPARATOR);
            int len = this.dedup(ts, 0, ts, 0, tsLength);
            return new ArrayTagSet(this.toStringArray(ts, len));
        }
        String[] newTags = new String[(this.length + tsLength) * 2];
        Arrays.sort(ts, 0, tsLength, TAG_COMPARATOR);
        int newLength = this.merge(newTags, this.tags, this.length, ts, tsLength);
        return new ArrayTagSet(newTags, newLength);
    }

    private String[] toStringArray(Tag[] ts, int length) {
        String[] strs = new String[length * 2];
        for (int i = 0; i < length; ++i) {
            strs[2 * i] = ts[i].key();
            strs[2 * i + 1] = ts[i].value();
        }
        return strs;
    }

    private int merge(String[] dst, String[] srcA, int lengthA, Tag[] srcB, int lengthB) {
        int i = 0;
        int ai = 0;
        int bi = 0;
        while (ai < lengthA && bi < lengthB) {
            int j;
            String ak = srcA[ai];
            String av = srcA[ai + 1];
            Tag b = srcB[bi];
            int cmp = ak.compareTo(b.key());
            if (cmp < 0) {
                dst[i++] = ak;
                dst[i++] = av;
                ai += 2;
                continue;
            }
            if (cmp > 0) {
                dst[i++] = b.key();
                dst[i++] = b.value();
                ++bi;
                continue;
            }
            for (j = bi + 1; j < lengthB && ak.equals(srcB[j].key()); ++j) {
                b = srcB[j];
            }
            dst[i++] = b.key();
            dst[i++] = b.value();
            bi = j;
            ai += 2;
        }
        if (ai < lengthA) {
            System.arraycopy(srcA, ai, dst, i, lengthA - ai);
            i += lengthA - ai;
        } else if (bi < lengthB) {
            i = this.dedup(srcB, bi, dst, i, lengthB - bi);
        }
        return i;
    }

    private int dedup(Tag[] src, int ss, Tag[] dst, int ds, int len) {
        if (len == 0) {
            return ds;
        }
        dst[ds] = src[ss];
        String k = src[ss].key();
        int j = ds;
        int e2 = ss + len;
        for (int i = ss + 1; i < e2; ++i) {
            if (k.equals(src[i].key())) {
                dst[j] = src[i];
                continue;
            }
            k = src[i].key();
            dst[++j] = src[i];
        }
        return j + 1;
    }

    private int dedup(Tag[] src, int ss, String[] dst, int ds, int len) {
        String k;
        if (len == 0) {
            return ds;
        }
        dst[ds] = k = src[ss].key();
        dst[ds + 1] = src[ss].value();
        int j = ds;
        int e2 = ss + len;
        for (int i = ss + 1; i < e2; ++i) {
            if (k.equals(src[i].key())) {
                dst[j] = src[i].key();
                dst[j + 1] = src[i].value();
                continue;
            }
            dst[j += 2] = k = src[i].key();
            dst[j + 1] = src[i].value();
        }
        return j + 2;
    }

    public int size() {
        return this.length / 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTagSet other = (ArrayTagSet)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.tags[i].equals(other.tags[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int result = this.length;
            for (int i = 0; i < this.length; ++i) {
                result = 31 * result + this.tags[i].hashCode();
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length; i += 2) {
            builder.append(':').append(this.tags[i]).append('=').append(this.tags[i + 1]);
        }
        return builder.toString();
    }
}

