/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.IoCContainer;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.exceptions.MappingException;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigMapper {
    private static final IoCContainer NULL_IOC_CONTAINER = new IoCContainer(){

        @Override
        public <T> T getInstance(String name2, Class<T> type2) {
            return null;
        }
    };

    public <T> void mapConfig(T injectee, Config config) throws MappingException {
        this.mapConfig(injectee, config, NULL_IOC_CONTAINER);
    }

    /*
     * WARNING - void declaration
     */
    public <T> void mapConfig(T injectee, Config config, IoCContainer ioc) throws MappingException {
        String objName;
        Object value;
        Configuration configAnnot = injectee.getClass().getAnnotation(Configuration.class);
        if (configAnnot == null) {
            return;
        }
        Class<?> injecteeType = injectee.getClass();
        String prefix = configAnnot.prefix();
        String[] params = configAnnot.params();
        if (params.length > 0) {
            void var11_15;
            AccessibleObject[] map2 = new HashMap();
            String[] stringArray = params;
            int n = stringArray.length;
            boolean i = false;
            while (var11_15 < n) {
                String param = stringArray[var11_15];
                try {
                    Field f = injecteeType.getDeclaredField(param);
                    f.setAccessible(true);
                    map2.put(param, f.get(injectee).toString());
                }
                catch (NoSuchFieldException e2) {
                    try {
                        Method method = injecteeType.getDeclaredMethod("get" + Character.toUpperCase(param.charAt(0)) + param.substring(1), new Class[0]);
                        method.setAccessible(true);
                        map2.put(param, method.invoke(injectee, new Object[0]).toString());
                    }
                    catch (Exception e1) {
                        throw new MappingException(e1);
                    }
                }
                catch (Exception e3) {
                    throw new MappingException(e3);
                }
                ++var11_15;
            }
            prefix = StrSubstitutor.replace(prefix, map2, "${", "}");
        }
        if (!(prefix = config.getStrInterpolator().create(ConfigStrLookup.from(config)).resolve(prefix)).isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (configAnnot.allowFields()) {
            for (AccessibleObject accessibleObject : injecteeType.getDeclaredFields()) {
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                String name2 = ((Field)accessibleObject).getName();
                Class<?> type2 = ((Field)accessibleObject).getType();
                value = null;
                if (type2.isInterface()) {
                    objName = config.getString(prefix + name2, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type2);
                    }
                } else {
                    value = config.get(type2, prefix + name2, null);
                }
                if (value == null) continue;
                try {
                    ((Field)accessibleObject).setAccessible(true);
                    ((Field)accessibleObject).set(injectee, value);
                }
                catch (Exception e4) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name2 + " with value " + value, e4);
                }
            }
        }
        if (configAnnot.allowSetters()) {
            for (AccessibleObject accessibleObject : injectee.getClass().getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterTypes().length != 1) continue;
                String name2 = ((Method)accessibleObject).getName();
                if (name2.startsWith("set") && name2.length() > 3) {
                    name2 = name2.substring(3, 4).toLowerCase() + name2.substring(4);
                } else {
                    if (!name2.startsWith("with") || name2.length() <= 4) continue;
                    name2 = name2.substring(4, 1).toLowerCase() + name2.substring(5);
                }
                ((Method)accessibleObject).setAccessible(true);
                Class<?> type2 = ((Method)accessibleObject).getParameterTypes()[0];
                value = null;
                if (type2.isInterface()) {
                    objName = config.getString(prefix + name2, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type2);
                    }
                } else {
                    value = config.get(type2, prefix + name2, null);
                }
                if (value == null) continue;
                try {
                    ((Method)accessibleObject).invoke(injectee, value);
                }
                catch (Exception e5) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name2 + " with value " + value, e5);
                }
            }
        }
        if (!configAnnot.postConfigure().isEmpty()) {
            try {
                Method m = injecteeType.getMethod(configAnnot.postConfigure(), new Class[0]);
                m.invoke(injectee, new Object[0]);
            }
            catch (Exception e6) {
                throw new MappingException("Unable to invoke postConfigure method " + configAnnot.postConfigure(), e6);
            }
        }
    }
}

