/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.reactivex.mantis.network.push.AsyncConnection;
import java.util.List;
import java.util.Set;
import rx.functions.Func1;

public abstract class Router<T> {
    protected Func1<T, byte[]> encoder;
    protected Counter numEventsRouted;
    protected Counter numEventsProcessed;
    private Metrics metrics;

    public Router(String name, Func1<T, byte[]> encoder) {
        this.encoder = encoder;
        this.metrics = new Metrics.Builder().name("Router_" + name).addCounter("numEventsRouted").addCounter("numEventsProcessed").build();
        this.numEventsRouted = this.metrics.getCounter("numEventsRouted");
        this.numEventsProcessed = this.metrics.getCounter("numEventsProcessed");
    }

    public abstract void route(Set<AsyncConnection<T>> var1, List<T> var2);

    public Metrics getMetrics() {
        return this.metrics;
    }
}

