/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.reactivex.mantis.network.push.AsyncConnection;
import io.reactivex.mantis.network.push.Router;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import rx.functions.Func1;

public class RoundRobinRouter<T>
extends Router<T> {
    public RoundRobinRouter(String name, Func1<T, byte[]> encoder) {
        super("RoundRobinRouter_" + name, encoder);
    }

    @Override
    public void route(Set<AsyncConnection<T>> connections, List<T> chunks) {
        if (chunks != null && !chunks.isEmpty()) {
            this.numEventsProcessed.increment((long)chunks.size());
        }
        ArrayList<AsyncConnection<T>> randomOrder = new ArrayList<AsyncConnection<T>>(connections);
        Collections.shuffle(randomOrder);
        if (chunks != null && !chunks.isEmpty() && !randomOrder.isEmpty()) {
            AsyncConnection connection;
            Iterator<AsyncConnection<T>> iter = this.loopingIterator(randomOrder);
            HashMap<AsyncConnection, LinkedList<Object>> writes = new HashMap<AsyncConnection, LinkedList<Object>>();
            for (T t : chunks) {
                connection = iter.next();
                Func1<T, Boolean> predicate = connection.getPredicate();
                if (predicate != null && !((Boolean)predicate.call(t)).booleanValue()) continue;
                LinkedList<Object> buffer = (LinkedList<Object>)writes.get(connection);
                if (buffer == null) {
                    buffer = new LinkedList<Object>();
                    writes.put(connection, buffer);
                }
                buffer.add(this.encoder.call(t));
            }
            if (!writes.isEmpty()) {
                for (Map.Entry entry : writes.entrySet()) {
                    connection = (AsyncConnection)entry.getKey();
                    List toWrite = (List)entry.getValue();
                    connection.write(toWrite);
                    this.numEventsRouted.increment((long)toWrite.size());
                }
            }
        }
    }

    private Iterator<AsyncConnection<T>> loopingIterator(final Collection<AsyncConnection<T>> connections) {
        final AtomicReference<Iterator<AsyncConnection<T>>> iterRef = new AtomicReference<Iterator<AsyncConnection<T>>>(connections.iterator());
        return new Iterator<AsyncConnection<T>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public AsyncConnection<T> next() {
                Iterator iter = (Iterator)iterRef.get();
                if (iter.hasNext()) {
                    return (AsyncConnection)iter.next();
                }
                iterRef.set(connections.iterator());
                return (AsyncConnection)((Iterator)iterRef.get()).next();
            }
        };
    }
}

