/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.compression.CompressionUtils;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.mql.jvm.core.Query;
import io.mantisrx.mql.shaded.clojure.java.api.Clojure;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.reactivex.mantis.network.push.PushServer;
import io.reactivex.mantis.network.push.PushTrigger;
import io.reactivex.mantis.network.push.ServerConfig;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.protocol.http.server.HttpServer;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.server.RequestHandler;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import mantis.io.reactivex.netty.server.RxServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;

public class PushServerSse<T, S>
extends PushServer<T, ServerSentEvent> {
    private static final Logger logger = LoggerFactory.getLogger(PushServerSse.class);
    public static final String PUSH_SERVER_METRIC_GROUP_NAME = "PushServerSse";
    public static final String PUSH_SERVER_LEGACY_METRIC_GROUP_NAME = "ServerSentEventRequestHandler";
    public static final String PROCESSED_COUNTER_METRIC_NAME = "processedCounter";
    public static final String DROPPED_COUNTER_METRIC_NAME = "droppedCounter";
    public static final String CLIENT_ID_TAG_NAME = "clientId";
    public static final String SOCK_ADDR_TAG_NAME = "sockAddr";
    private static IFn require = Clojure.var((Object)"io.mantisrx.mql.shaded.clojure.core", (Object)"require");
    private static IFn mqlMakeQuery;
    private static IFn mqlParses;
    private Func2<Map<String, List<String>>, S, Void> requestPreprocessor;
    private Func2<Map<String, List<String>>, S, Void> requestPostprocessor;
    private final Func2<Map<String, List<String>>, S, Void> subscribeProcessor;
    private S processorState;
    private Func1<Map<String, List<String>>, Func1<T, Boolean>> predicate;
    private boolean supportLegacyMetrics;
    private MetricsRegistry metricsRegistry;

    public PushServerSse(PushTrigger<T> trigger, ServerConfig<T> config, PublishSubject<String> serverSignals, Func2<Map<String, List<String>>, S, Void> requestPreprocessor, Func2<Map<String, List<String>>, S, Void> requestPostprocessor, Func2<Map<String, List<String>>, S, Void> subscribeProcessor, S state, boolean supportLegacyMetrics) {
        super(trigger, config, (Observable<String>)serverSignals);
        this.metricsRegistry = config.getMetricsRegistry();
        this.predicate = config.getPredicate();
        this.processorState = state;
        this.requestPostprocessor = requestPostprocessor;
        this.requestPreprocessor = requestPreprocessor;
        this.subscribeProcessor = subscribeProcessor;
        this.supportLegacyMetrics = supportLegacyMetrics;
    }

    private Metrics registerSseMetrics(String uniqueClientId, String socketAddrStr) {
        BasicTag clientIdTag = new BasicTag(CLIENT_ID_TAG_NAME, Optional.ofNullable(uniqueClientId).orElse("none"));
        BasicTag sockAddrTag = new BasicTag(SOCK_ADDR_TAG_NAME, Optional.ofNullable(socketAddrStr).orElse("none"));
        String metricGroup = this.supportLegacyMetrics ? PUSH_SERVER_LEGACY_METRIC_GROUP_NAME : PUSH_SERVER_METRIC_GROUP_NAME;
        Metrics sseSinkMetrics = new Metrics.Builder().id(metricGroup, new Tag[]{clientIdTag, sockAddrTag}).addCounter(PROCESSED_COUNTER_METRIC_NAME).addCounter(DROPPED_COUNTER_METRIC_NAME).build();
        sseSinkMetrics = this.metricsRegistry.registerAndGet(sseSinkMetrics);
        return sseSinkMetrics;
    }

    @Override
    public RxServer<?, ?> createServer() {
        HttpServer server = ((HttpServerBuilder)((HttpServerBuilder)RxNetty.newHttpServerBuilder((int)this.port, (RequestHandler)new RequestHandler<String, ServerSentEvent>(){

            public Observable<Void> handle(HttpServerRequest<String> request, HttpServerResponse<ServerSentEvent> response) {
                Metrics metrics;
                final Map queryParameters = request.getQueryParameters();
                boolean enableHeartbeats = false;
                boolean enableBinaryOutput = false;
                AtomicLong heartBeatReadIdleSec = new AtomicLong(2L);
                SerializedSubject metaMsgSubject = PublishSubject.create().toSerialized();
                AtomicLong metaMessagesFreqMSec = new AtomicLong(1000L);
                boolean enableMetaMessages = false;
                AtomicLong lastWriteTime = new AtomicLong();
                Subscription heartbeatSubscription = null;
                Subscription metaMsgSubscription = null;
                boolean enableSampling = false;
                long samplingTimeMsec = 0L;
                String groupId = null;
                String slotId = null;
                String id = null;
                Func1 predicateFunction = null;
                if (PushServerSse.this.predicate != null) {
                    predicateFunction = (Func1)PushServerSse.this.predicate.call((Object)queryParameters);
                }
                byte[] delimiter = CompressionUtils.MANTIS_SSE_DELIMITER_BINARY;
                if (queryParameters != null && !queryParameters.isEmpty()) {
                    String rawDelimiter;
                    String enableMetaMessagesStr;
                    String enablePings;
                    String enableBinaryOutputStr;
                    if (queryParameters.containsKey("id")) {
                        id = (String)((List)queryParameters.get("id")).get(0);
                    }
                    if (queryParameters.containsKey("slotId")) {
                        slotId = (String)((List)queryParameters.get("slotId")).get(0);
                    }
                    if (queryParameters.containsKey("groupId")) {
                        groupId = (String)((List)queryParameters.get("groupId")).get(0);
                    }
                    if (queryParameters.containsKey(PushServerSse.CLIENT_ID_TAG_NAME)) {
                        groupId = (String)((List)queryParameters.get(PushServerSse.CLIENT_ID_TAG_NAME)).get(0);
                    }
                    if (queryParameters.containsKey("heartbeatSec")) {
                        heartBeatReadIdleSec.set(Long.parseLong((String)((List)queryParameters.get("heartbeatSec")).get(0)));
                        if (heartBeatReadIdleSec.get() < 1L) {
                            throw new IllegalArgumentException("Sampling rate too low: " + samplingTimeMsec);
                        }
                        enableHeartbeats = true;
                    }
                    if (queryParameters != null && queryParameters.containsKey("mantis.EnableCompressedBinary") && "true".equalsIgnoreCase(enableBinaryOutputStr = (String)((List)queryParameters.get("mantis.EnableCompressedBinary")).get(0))) {
                        logger.info("Binary compression requested");
                        enableBinaryOutput = true;
                    }
                    if (queryParameters.containsKey("enablePings") && "true".equalsIgnoreCase(enablePings = (String)((List)queryParameters.get("enablePings")).get(0))) {
                        enableHeartbeats = true;
                    }
                    if (queryParameters.containsKey("enableMetaMessages") && "true".equalsIgnoreCase(enableMetaMessagesStr = (String)((List)queryParameters.get("enableMetaMessages")).get(0))) {
                        enableMetaMessages = true;
                    }
                    if (queryParameters.containsKey("metaMessagesSec")) {
                        metaMessagesFreqMSec.set(Long.parseLong((String)((List)queryParameters.get("metaMessagesSec")).get(0)));
                        if (metaMessagesFreqMSec.get() < 250L) {
                            throw new IllegalArgumentException("Meta message frequence rate too low: " + metaMessagesFreqMSec.get());
                        }
                        enableMetaMessages = true;
                    }
                    if (queryParameters.containsKey("sample")) {
                        samplingTimeMsec = Long.parseLong((String)((List)queryParameters.get("sample")).get(0)) * 1000L;
                        if (samplingTimeMsec < 50L) {
                            throw new IllegalArgumentException("Sampling rate too low: " + samplingTimeMsec);
                        }
                        enableSampling = true;
                    }
                    if (queryParameters.containsKey("sampleMSec")) {
                        samplingTimeMsec = Long.parseLong((String)((List)queryParameters.get("sampleMSec")).get(0));
                        if (samplingTimeMsec < 50L) {
                            throw new IllegalArgumentException("Sampling rate too low: " + samplingTimeMsec);
                        }
                        enableSampling = true;
                    }
                    if (queryParameters.containsKey("mantis.CompressionDelimiter") && (rawDelimiter = (String)((List)queryParameters.get("mantis.CompressionDelimiter")).get(0)) != null && !rawDelimiter.isEmpty()) {
                        delimiter = rawDelimiter.getBytes();
                    }
                    if (queryParameters.containsKey("mql")) {
                        String query = (String)((List)queryParameters.get("mql")).get(0);
                        if (((Boolean)mqlParses.invoke((Object)query)).booleanValue()) {
                            Query q = (Query)mqlMakeQuery.invoke((Object)groupId, (Object)query);
                            predicateFunction = datum -> datum instanceof Map ? q.matches((Map)datum) : true;
                        }
                    }
                }
                InetSocketAddress socketAddress = (InetSocketAddress)response.getChannel().remoteAddress();
                if (groupId == null) {
                    String address = socketAddress.getAddress().toString();
                    metrics = PushServerSse.this.registerSseMetrics(address, address);
                } else {
                    metrics = PushServerSse.this.registerSseMetrics(groupId, socketAddress.getAddress().toString());
                }
                Counter sseProcessedCounter = metrics.getCounter(PushServerSse.PROCESSED_COUNTER_METRIC_NAME);
                Counter sseDroppedCounter = metrics.getCounter(PushServerSse.DROPPED_COUNTER_METRIC_NAME);
                response.getHeaders().set("Access-Control-Allow-Origin", (Object)"*");
                response.getHeaders().set("content-type", (Object)"text/event-stream");
                response.getHeaders().set("Cache-Control", (Object)"no-cache, no-store, max-age=0, must-revalidate");
                response.getHeaders().set("Pragma", (Object)"no-cache");
                response.flush();
                if (queryParameters != null && PushServerSse.this.requestPreprocessor != null) {
                    PushServerSse.this.requestPreprocessor.call((Object)queryParameters, PushServerSse.this.processorState);
                }
                if (enableMetaMessages && metaMessagesFreqMSec.get() > 0L) {
                    logger.info("Enabling Meta messages, interval : " + metaMessagesFreqMSec.get() + " ms");
                    metaMsgSubscription = metaMsgSubject.throttleLast(metaMessagesFreqMSec.get(), TimeUnit.MILLISECONDS).doOnNext(t -> {
                        if (t != null && !t.isEmpty()) {
                            long currentTime = System.currentTimeMillis();
                            ByteBuf data = response.getAllocator().buffer().writeBytes(t.getBytes());
                            response.writeAndFlush((Object)new ServerSentEvent(data));
                            lastWriteTime.set(currentTime);
                        }
                    }).subscribe();
                }
                if (enableHeartbeats && heartBeatReadIdleSec.get() > 0L) {
                    logger.info("Enabling hearts, interval: " + heartBeatReadIdleSec);
                    heartbeatSubscription = Observable.interval((long)2L, (long)heartBeatReadIdleSec.get(), (TimeUnit)TimeUnit.SECONDS).doOnNext(t1 -> {
                        long currentTime = System.currentTimeMillis();
                        long diff = (currentTime - lastWriteTime.get()) / 1000L;
                        if (diff > heartBeatReadIdleSec.get()) {
                            ByteBuf data = response.getAllocator().buffer().writeBytes("ping".getBytes());
                            response.writeAndFlush((Object)new ServerSentEvent(data));
                            lastWriteTime.set(currentTime);
                        }
                    }).subscribe();
                }
                Action0 connectionClosedCallback = null;
                if (queryParameters != null && PushServerSse.this.requestPostprocessor != null) {
                    connectionClosedCallback = new Action0(){

                        public void call() {
                            PushServerSse.this.requestPostprocessor.call((Object)queryParameters, PushServerSse.this.processorState);
                        }
                    };
                }
                class SubscribeCallback
                implements Action0 {
                    SubscribeCallback() {
                    }

                    public void call() {
                        if (queryParameters != null && PushServerSse.this.subscribeProcessor != null) {
                            PushServerSse.this.subscribeProcessor.call((Object)queryParameters, PushServerSse.this.processorState);
                        }
                    }
                }
                return PushServerSse.this.manageConnectionWithCompression(response, socketAddress.getHostString(), socketAddress.getPort(), groupId, slotId, id, lastWriteTime, enableHeartbeats, heartbeatSubscription, enableSampling, samplingTimeMsec, (SerializedSubject<String, String>)metaMsgSubject, metaMsgSubscription, predicateFunction, connectionClosedCallback, sseProcessedCounter, sseDroppedCounter, new SubscribeCallback(), enableBinaryOutput, true, delimiter);
            }
        }).pipelineConfigurator(PipelineConfigurators.serveSseConfigurator())).channelOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x500000))).build();
        return server;
    }

    static {
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.core"));
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.server"));
        mqlMakeQuery = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.server", (Object)"make-query");
        mqlParses = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"parses?");
    }
}

