/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.reactivex.mantis.network.push.ChunkProcessor;
import io.reactivex.mantis.network.push.Chunker;
import io.reactivex.mantis.network.push.ConnectionManager;
import io.reactivex.mantis.network.push.MonitoredQueue;
import io.reactivex.mantis.network.push.NamedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimedChunker<T>
implements Callable<Void> {
    private static ThreadFactory namedFactory = new NamedThreadFactory("TimedChunkerGroup");
    private MonitoredQueue<T> buffer;
    private ChunkProcessor<T> processor;
    private ExecutorService timerPool = Executors.newSingleThreadExecutor(namedFactory);
    private int maxBufferLength;
    private int maxTimeMSec;
    private ConnectionManager<T> connectionManager;
    private Counter chunkerCancelSuccessInterrupted;
    private Counter chunkerCancelFailureInterrupted;
    private Counter chunkerCancelSuccessTimeout;
    private Counter chunkerCancelFailureTimeout;
    private Counter chunkerCancelSuccessExecution;
    private Counter chunkerCancelFailureExecution;

    public TimedChunker(MonitoredQueue<T> buffer, int maxBufferLength, int maxTimeMSec, ChunkProcessor<T> processor, ConnectionManager<T> connectionManager) {
        this.maxBufferLength = maxBufferLength;
        this.maxTimeMSec = maxTimeMSec;
        this.buffer = buffer;
        this.processor = processor;
        this.connectionManager = connectionManager;
        MetricGroupId metricsGroup = new MetricGroupId("TimedChunker");
        Metrics metrics = new Metrics.Builder().id(metricsGroup).addCounter("chunkerCancelSuccess_interrupted").addCounter("chunkerCancelFailure_interrupted").addCounter("chunkerCancelSuccess_timeout").addCounter("chunkerCancelFailure_timeout").addCounter("chunkerCancelSuccess_execution").addCounter("chunkerCancelFailure_execution").build();
        this.chunkerCancelSuccessInterrupted = metrics.getCounter("chunkerCancelSuccess_interrupted");
        this.chunkerCancelFailureInterrupted = metrics.getCounter("chunkerCancelFailure_interrupted");
        this.chunkerCancelSuccessTimeout = metrics.getCounter("chunkerCancelSuccess_timeout");
        this.chunkerCancelFailureTimeout = metrics.getCounter("chunkerCancelFailure_timeout");
        this.chunkerCancelSuccessExecution = metrics.getCounter("chunkerCancelSuccess_execution");
        this.chunkerCancelFailureExecution = metrics.getCounter("chunkerCancelFailure_execution");
        MetricsRegistry.getInstance().registerAndGet(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        while (!this.stopCondition()) {
            boolean timeoutException = false;
            boolean executionException = false;
            T data = this.buffer.get();
            Future<Void> queryFuture = this.timerPool.submit(new Chunker<T>(this.processor, data, this.buffer, this.maxBufferLength, this.connectionManager));
            try {
                queryFuture.get(this.maxTimeMSec, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                boolean success = queryFuture.cancel(true);
                if (success) {
                    this.chunkerCancelSuccessInterrupted.increment();
                } else {
                    this.chunkerCancelFailureInterrupted.increment();
                }
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                executionException = true;
                throw e;
            }
            catch (TimeoutException e) {
                timeoutException = true;
            }
            finally {
                boolean success = queryFuture.cancel(true);
                if (timeoutException) {
                    if (success) {
                        this.chunkerCancelSuccessTimeout.increment();
                        continue;
                    }
                    this.chunkerCancelFailureTimeout.increment();
                    continue;
                }
                if (!executionException) continue;
                if (success) {
                    this.chunkerCancelSuccessExecution.increment();
                    continue;
                }
                this.chunkerCancelFailureExecution.increment();
            }
        }
        return null;
    }

    private boolean stopCondition() {
        return Thread.currentThread().isInterrupted();
    }
}

