/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.reactivex.mantis.network.push.ChunkProcessor;
import io.reactivex.mantis.network.push.ConnectionManager;
import io.reactivex.mantis.network.push.MonitoredQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chunker<T>
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger(Chunker.class);
    private MonitoredQueue<T> outboundBuffer;
    private List<T> internalBuffer;
    private int internalBufferSize;
    private ChunkProcessor<T> processor;
    private ConnectionManager<T> connectionManager;

    public Chunker(ChunkProcessor<T> processor, T firstRead, MonitoredQueue<T> outboundBuffer, int internalBufferSize, ConnectionManager<T> connectionManager) {
        this.outboundBuffer = outboundBuffer;
        this.processor = processor;
        this.internalBufferSize = internalBufferSize;
        this.connectionManager = connectionManager;
        this.internalBuffer = new ArrayList<T>(internalBufferSize);
        this.internalBuffer.add(firstRead);
        if (internalBufferSize == 1) {
            this.drain();
        }
    }

    @Override
    public Void call() throws Exception {
        while (!this.stopCondition()) {
            try {
                this.internalBuffer.add(this.outboundBuffer.get());
                if (this.internalBuffer.size() < this.internalBufferSize) continue;
                this.drain();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.warn("Error occured chunking data", (Throwable)e);
            }
        }
        this.drain();
        return null;
    }

    private void drain() {
        int size = this.internalBuffer.size();
        if (size > 0) {
            ArrayList<T> copy = new ArrayList<T>(size);
            copy.addAll(this.internalBuffer);
            this.processor.process(this.connectionManager, copy);
            this.internalBuffer.clear();
        }
    }

    private boolean stopCondition() {
        return Thread.currentThread().isInterrupted();
    }
}

