/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteRxEvent {
    private String name;
    private Type type;
    private byte[] data;
    private Map<String, String> subscriptionParameters;

    public RemoteRxEvent(String name, Type type, byte[] data, Map<String, String> subscriptionParameters) {
        this.name = name;
        this.type = type;
        this.data = data;
        this.subscriptionParameters = subscriptionParameters;
    }

    public static List<RemoteRxEvent> heartbeat() {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(null, Type.heartbeat, null, null));
        return list;
    }

    public static RemoteRxEvent nonDataError(String name, byte[] errorData) {
        return new RemoteRxEvent(null, Type.nonDataError, errorData, null);
    }

    public static RemoteRxEvent next(String name, byte[] nextData) {
        return new RemoteRxEvent(name, Type.next, nextData, null);
    }

    public static RemoteRxEvent completed(String name) {
        return new RemoteRxEvent(name, Type.completed, null, null);
    }

    public static RemoteRxEvent error(String name, byte[] errorData) {
        return new RemoteRxEvent(name, Type.error, errorData, null);
    }

    public static List<RemoteRxEvent> subscribed(String name, Map<String, String> subscriptionParameters) {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(name, Type.subscribed, null, subscriptionParameters));
        return list;
    }

    public static List<RemoteRxEvent> unsubscribed(String name) {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(name, Type.unsubscribed, null, null));
        return list;
    }

    public byte[] getData() {
        return this.data;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    Map<String, String> getSubscribeParameters() {
        return this.subscriptionParameters;
    }

    public String toString() {
        return "RemoteRxEvent [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", subscriptionParameters=" + this.subscriptionParameters + "]";
    }

    public static enum Type {
        next,
        completed,
        error,
        subscribed,
        unsubscribed,
        heartbeat,
        nonDataError;

    }
}

