/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import java.util.AbstractQueue;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import org.jctools.queues.SpscArrayQueue;

public class MonitoredQueue<T> {
    final boolean isSpsc;
    private AbstractQueue<T> queue;
    private Metrics metrics;
    private Counter numSuccessEnqueu;
    private Counter numFailedEnqueu;

    public MonitoredQueue(String name, int capacity) {
        this(name, capacity, true);
    }

    public MonitoredQueue(String name, int capacity, boolean useSpsc) {
        this.isSpsc = useSpsc;
        this.queue = !useSpsc ? new LinkedBlockingQueue<T>(capacity) : new SpscArrayQueue(capacity);
        String qId = Optional.ofNullable(name).orElse("none");
        BasicTag idTag = new BasicTag("groupId", qId);
        MetricGroupId metricGroup = new MetricGroupId("MonitoredQueue", new Tag[]{idTag});
        GaugeCallback queueDepth = new GaugeCallback(metricGroup, "queueDepth", () -> this.queue.size());
        this.metrics = new Metrics.Builder().id(metricGroup).addCounter("numFailedToQueue").addCounter("numSuccessQueued").addGauge((Gauge)queueDepth).build();
        this.numSuccessEnqueu = this.metrics.getCounter("numSuccessQueued");
        this.numFailedEnqueu = this.metrics.getCounter("numFailedToQueue");
    }

    public boolean write(T data) {
        boolean offer = this.queue.offer(data);
        if (offer) {
            this.numSuccessEnqueu.increment();
        } else {
            this.numFailedEnqueu.increment();
        }
        return offer;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public T get() throws InterruptedException {
        if (!this.isSpsc) {
            return (T)((LinkedBlockingQueue)this.queue).take();
        }
        return (T)this.queue.poll();
    }

    public T poll() {
        return (T)this.queue.poll();
    }

    public void clear() {
        this.queue.clear();
    }
}

