/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.examples.wordcount.sources;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.source.Index;
import io.mantisrx.runtime.source.Source;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import rx.Observable;

public class IlliadSource
implements Source<String> {
    private static final Logger log = Logger.getLogger(IlliadSource.class);

    public Observable<Observable<String>> call(Context context, Index index) {
        return Observable.interval((long)10L, (TimeUnit)TimeUnit.SECONDS).map(__ -> {
            try {
                Path path = Paths.get(this.getClass().getClassLoader().getResource("illiad.txt").toURI());
                return Observable.from(() -> {
                    try {
                        return Files.lines(path).iterator();
                    }
                    catch (IOException ex) {
                        log.error((Object)"IOException while reading illiad.txt from resources", (Throwable)ex);
                        return Stream.empty().iterator();
                    }
                });
            }
            catch (URISyntaxException ex) {
                log.error((Object)"URISyntaxException while loading illiad.txt from resources.", (Throwable)ex);
                return Observable.empty();
            }
        });
    }

    public void close() throws IOException {
    }
}

