/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.examples.wordcount;

import com.netflix.mantis.examples.config.StageConfigs;
import com.netflix.mantis.examples.core.WordCountPair;
import com.netflix.mantis.examples.wordcount.sources.IlliadSource;
import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.MantisJob;
import io.mantisrx.runtime.MantisJobProvider;
import io.mantisrx.runtime.Metadata;
import io.mantisrx.runtime.executor.LocalJobExecutorNetworked;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.runtime.sink.SelfDocumentingSink;
import io.mantisrx.runtime.sink.Sinks;
import io.mantisrx.runtime.source.Source;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class WordCountJob
extends MantisJobProvider<String> {
    private static final Logger log = LoggerFactory.getLogger(WordCountJob.class);

    public Job<String> getJobInstance() {
        return MantisJob.source((Source)new IlliadSource()).stage((context, dataO) -> dataO.flatMap(text -> Observable.from(this.tokenize((String)text))).window(10L, TimeUnit.SECONDS).flatMap(wordCountPairObservable -> wordCountPairObservable.groupBy(WordCountPair::getWord).flatMap(groupO -> groupO.reduce((Object)0, (cnt, wordCntPair) -> cnt + 1).map(cnt -> new WordCountPair((String)groupO.getKey(), cnt.intValue())))).map(WordCountPair::toString), StageConfigs.scalarToScalarConfig()).sink(Sinks.eagerSubscribe((SelfDocumentingSink)Sinks.sse(data -> data))).metadata(new Metadata.Builder().name("WordCount").description("Reads Homer's The Illiad faster than we can.").build()).create();
    }

    private List<WordCountPair> tokenize(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        ArrayList<WordCountPair> wordCountPairs = new ArrayList<WordCountPair>();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken().replaceAll("\\s*", "").toLowerCase();
            wordCountPairs.add(new WordCountPair(word, 1));
        }
        return wordCountPairs;
    }

    public static void main(String[] args) {
        LocalJobExecutorNetworked.execute(new WordCountJob().getJobInstance(), (Parameter[])new Parameter[0]);
    }
}

