/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.core;

import io.mantisrx.mql.jvm.core.Query;
import io.mantisrx.sourcejob.synthetic.core.MQL;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class MQLQueryManager {
    private ConcurrentHashMap<String, Query> queries = new ConcurrentHashMap();

    public static MQLQueryManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    private MQLQueryManager() {
    }

    public void registerQuery(String id, String query) {
        query = MQL.transformLegacyQuery(query);
        Query q = MQL.makeQuery(id, query);
        this.queries.put(id, q);
    }

    public void deregisterQuery(String id) {
        this.queries.remove(id);
    }

    public Collection<Query> getRegisteredQueries() {
        return this.queries.values();
    }

    public void clear() {
        this.queries.clear();
    }

    public static void main(String[] args) throws Exception {
        MQLQueryManager qm = MQLQueryManager.getInstance();
        String query = "SELECT * WHERE true SAMPLE {\"strategy\":\"RANDOM\",\"threshold\":1}";
        qm.registerQuery("fake2", query);
        System.out.println(MQL.parses(MQL.transformLegacyQuery(query)));
        System.out.println(MQL.getParseError(MQL.transformLegacyQuery(query)));
        System.out.println(qm.getRegisteredQueries());
    }

    static class LazyHolder {
        private static final MQLQueryManager INSTANCE = new MQLQueryManager();

        LazyHolder() {
        }
    }
}

