/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.sink;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.PortRequest;
import io.mantisrx.runtime.sink.ServerSentEventsSink;
import io.mantisrx.runtime.sink.Sink;
import io.mantisrx.runtime.sink.predicate.Predicate;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.sourcejob.synthetic.core.TaggedData;
import io.mantisrx.sourcejob.synthetic.sink.TaggedEventFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;

public class TaggedDataSourceSink
implements Sink<TaggedData> {
    private static final Logger log = LoggerFactory.getLogger(TaggedDataSourceSink.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final ServerSentEventsSink<TaggedData> sink;
    private Subscription subscription;

    public TaggedDataSourceSink() {
        this(new NoOpProcessor(), new NoOpProcessor());
    }

    public TaggedDataSourceSink(Func2<Map<String, List<String>>, Context, Void> preProcessor, Func2<Map<String, List<String>>, Context, Void> postProcessor) {
        this.sink = new ServerSentEventsSink.Builder().withEncoder(data -> {
            try {
                return OBJECT_MAPPER.writeValueAsString(data.getPayload());
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return "{\"error\":" + e.getMessage() + "}";
            }
        }).withPredicate(new Predicate("description", (Func1)new TaggedEventFilter())).withRequestPreprocessor(preProcessor).withRequestPostprocessor(postProcessor).build();
    }

    public void call(Context context, PortRequest portRequest, Observable<TaggedData> observable) {
        observable = observable.filter(t1 -> !t1.getPayload().isEmpty());
        observable.subscribe();
        this.sink.call(context, portRequest, observable);
    }

    public void close() throws IOException {
        try {
            this.sink.close();
        }
        finally {
            this.subscription.unsubscribe();
        }
    }

    static class NoOpProcessor
    implements Func2<Map<String, List<String>>, Context, Void> {
        NoOpProcessor() {
        }

        public Void call(Map<String, List<String>> t1, Context t2) {
            return null;
        }
    }
}

