/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.source;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.type.IntParameter;
import io.mantisrx.runtime.parameter.validator.Validators;
import io.mantisrx.runtime.source.Index;
import io.mantisrx.runtime.source.Source;
import io.mantisrx.sourcejob.synthetic.proto.RequestEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.andreinc.mockneat.MockNeat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class SyntheticSource
implements Source<String> {
    private static final Logger log = LoggerFactory.getLogger(SyntheticSource.class);
    private static final String DATA_GENERATION_RATE_MSEC_PARAM = "dataGenerationRate";
    private MockNeat mockDataGenerator;
    private int dataGenerateRateMsec = 250;

    public Observable<Observable<String>> call(Context context, Index index) {
        return Observable.just((Object)Observable.interval((long)this.dataGenerateRateMsec, (TimeUnit)TimeUnit.MILLISECONDS).map(tick -> this.generateEvent()).map(event -> event.toJsonString()).filter(Objects::nonNull).doOnNext(event -> log.debug("Generated Event {}", event)));
    }

    public void init(Context context, Index index) {
        this.mockDataGenerator = MockNeat.threadLocal();
        this.dataGenerateRateMsec = (Integer)context.getParameters().get(DATA_GENERATION_RATE_MSEC_PARAM, (Object)250);
    }

    public List<ParameterDefinition<?>> getParameters() {
        ArrayList params = new ArrayList();
        params.add(new IntParameter().name(DATA_GENERATION_RATE_MSEC_PARAM).description("Rate at which to generate data").validator(Validators.range((Number)100, (Number)1000000)).defaultValue((Object)250).build());
        return params;
    }

    private RequestEvent generateEvent() {
        String path = (String)this.mockDataGenerator.probabilites(String.class).add(Double.valueOf(0.1), (Object)"/login").add(Double.valueOf(0.2), (Object)"/genre/horror").add(Double.valueOf(0.5), (Object)"/genre/comedy").add(Double.valueOf(0.2), (Object)"/mylist").get();
        String deviceType = (String)this.mockDataGenerator.probabilites(String.class).add(Double.valueOf(0.1), (Object)"ps4").add(Double.valueOf(0.1), (Object)"xbox").add(Double.valueOf(0.2), (Object)"browser").add(Double.valueOf(0.3), (Object)"ios").add(Double.valueOf(0.3), (Object)"android").get();
        String userId = (String)this.mockDataGenerator.strings().size(10).get();
        int status = (Integer)this.mockDataGenerator.probabilites(Integer.class).add(Double.valueOf(0.1), (Object)500).add(Double.valueOf(0.7), (Object)200).add(Double.valueOf(0.2), (Object)500).get();
        String country = (String)this.mockDataGenerator.countries().names().get();
        return RequestEvent.builder().status(status).uri(path).country(country).userId(userId).deviceType(deviceType).build();
    }

    public void close() throws IOException {
    }
}

