/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.core;

import io.mantisrx.mql.jvm.core.Query;
import io.mantisrx.mql.shaded.clojure.java.api.Clojure;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class MQL {
    private static IFn require = Clojure.var((Object)"io.mantisrx.mql.shaded.clojure.core", (Object)"require");
    private static IFn cljMakeQuery;
    private static IFn cljSuperset;
    private static IFn parser;
    private static IFn parses;
    private static IFn getParseError;
    private static IFn queryToGroupByFn;
    private static IFn queryToHavingPred;
    private static IFn queryToOrderBy;
    private static IFn queryToLimit;
    private static IFn queryToExtrapolationFn;
    private static IFn queryToAggregateFn;
    private static IFn queryToWindow;
    private static Logger logger;
    private static ConcurrentHashMap<HashSet<Query>, IFn> superSetProjectorCache;
    private final String query;
    private final boolean threadingEnabled;
    private final Optional<String> sourceJobName;

    public static void init() {
        logger.info("Initializing MQL runtime.");
    }

    public MQL(String query, boolean threadingEnabled) {
        if (query == null) {
            throw new IllegalArgumentException("MQL cannot be used as an operator with a null query.");
        }
        this.query = MQL.transformLegacyQuery(query);
        if (!MQL.parses(query).booleanValue()) {
            throw new IllegalArgumentException(MQL.getParseError(query));
        }
        this.threadingEnabled = threadingEnabled;
        this.sourceJobName = Optional.empty();
    }

    public MQL(String query, String sourceJobName) {
        if (query == null) {
            throw new IllegalArgumentException("MQL cannot be used as an operator with a null query.");
        }
        this.query = MQL.transformLegacyQuery(query);
        if (!MQL.parses(query).booleanValue()) {
            throw new IllegalArgumentException(MQL.getParseError(query));
        }
        this.threadingEnabled = false;
        this.sourceJobName = Optional.ofNullable(sourceJobName);
    }

    public static MQL parse(String query) {
        return new MQL(query, false);
    }

    public static MQL parse(String query, boolean threadingEnabled) {
        return new MQL(query, threadingEnabled);
    }

    public static MQL parse(String query, String sourceName) {
        return new MQL(query, sourceName);
    }

    public static Query makeQuery(String subscriptionId, String query) {
        return (Query)cljMakeQuery.invoke((Object)subscriptionId, (Object)query.trim());
    }

    private static IFn computeSuperSetProjector(HashSet<Query> queries) {
        ArrayList<String> qs = new ArrayList<String>(queries.size());
        for (Query query : queries) {
            qs.add(query.getRawQuery());
        }
        return (IFn)cljSuperset.invoke(new ArrayList(qs));
    }

    public static Map<String, Object> projectSuperSet(Collection<Query> queries, Map<String, Object> datum) {
        IFn superSetProjector = superSetProjectorCache.computeIfAbsent(new HashSet<Query>(queries), qs -> MQL.computeSuperSetProjector(qs));
        return (Map)superSetProjector.invoke(datum);
    }

    public static Func1<Map<String, Object>, Object> getGroupByFn(String query) {
        IFn func = (IFn)queryToGroupByFn.invoke((Object)query);
        return arg_0 -> ((IFn)func).invoke(arg_0);
    }

    public static Func1<Map<String, Object>, Boolean> getHavingPredicate(String query) {
        IFn func = (IFn)queryToHavingPred.invoke((Object)query);
        return datum -> (Boolean)func.invoke(datum);
    }

    public static Func1<Observable<Map<String, Object>>, Observable<Map<String, Object>>> getAggregateFn(String query) {
        IFn func = (IFn)queryToAggregateFn.invoke((Object)query);
        return obs -> (Observable)func.invoke(obs);
    }

    public static Func1<Map<String, Object>, Map<String, Object>> getExtrapolationFn(String query) {
        IFn func = (IFn)queryToExtrapolationFn.invoke((Object)query);
        return datum -> (Map)func.invoke(datum);
    }

    public static Func1<Observable<Map<String, Object>>, Observable<Map<String, Object>>> getOrderBy(String query) {
        IFn func = (IFn)queryToOrderBy.invoke((Object)query);
        return obs -> (Observable)func.invoke(obs);
    }

    public static Long getLimit(String query) {
        return (Long)queryToLimit.invoke((Object)query);
    }

    public static Boolean parses(String query) {
        return (Boolean)parses.invoke((Object)query);
    }

    public static String getParseError(String query) {
        return (String)getParseError.invoke((Object)query);
    }

    public static String transformLegacyQuery(String criterion) {
        return criterion.toLowerCase().equals("true") ? "select * where true" : (criterion.toLowerCase().equals("false") ? "select * where false" : criterion);
    }

    public static void main(String[] args) {
        System.out.println(MQL.makeQuery("abc", "select * from stream where true"));
    }

    static {
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.core"));
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.server"));
        cljMakeQuery = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.server", (Object)"make-query");
        cljSuperset = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"queries->superset-projection");
        parser = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"parser");
        parses = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"parses?");
        getParseError = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"get-parse-error");
        queryToGroupByFn = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->groupby");
        queryToHavingPred = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->having-pred");
        queryToOrderBy = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->orderby");
        queryToLimit = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->limit");
        queryToExtrapolationFn = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->extrapolator");
        queryToAggregateFn = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"agg-query->projection");
        queryToWindow = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"query->window");
        logger = LoggerFactory.getLogger(MQL.class);
        superSetProjectorCache = new ConcurrentHashMap();
    }
}

