/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.sink;

import io.mantisrx.sourcejob.synthetic.core.MQLQueryManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryRefCountMap {
    private static final Logger log = LoggerFactory.getLogger(QueryRefCountMap.class);
    public static final QueryRefCountMap INSTANCE = new QueryRefCountMap();
    private final ConcurrentHashMap<String, AtomicInteger> refCntMap = new ConcurrentHashMap();

    private QueryRefCountMap() {
    }

    void addQuery(String subId, String query) {
        log.info("adding query " + subId + " query " + query);
        if (this.refCntMap.containsKey(subId)) {
            int newVal = this.refCntMap.get(subId).incrementAndGet();
            log.info("query exists already incrementing refcnt to " + newVal);
        } else {
            MQLQueryManager.getInstance().registerQuery(subId, query);
            this.refCntMap.putIfAbsent(subId, new AtomicInteger(1));
            log.info("new query registering it");
        }
    }

    void removeQuery(String subId) {
        if (this.refCntMap.containsKey(subId)) {
            AtomicInteger refCnt = this.refCntMap.get(subId);
            int currVal = refCnt.decrementAndGet();
            if (currVal == 0) {
                MQLQueryManager.getInstance().deregisterQuery(subId);
                this.refCntMap.remove(subId);
                log.info("All references to query are gone removing query");
            } else {
                log.info("References to query still exist. decrementing refcnt to " + currVal);
            }
        } else {
            log.warn("No query with subscriptionId " + subId);
        }
    }

    int getQueryRefCount(String subId) {
        if (this.refCntMap.containsKey(subId)) {
            return this.refCntMap.get(subId).get();
        }
        return 0;
    }
}

